/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.transform.vector;

import com.builtbroken.atomic.lib.transform.IPosWorld;
import com.builtbroken.atomic.lib.transform.vector.AbstractLocation;
import com.builtbroken.jlib.data.vector.IPos3D;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.ILocation;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class Location
extends AbstractLocation<Location>
implements IPosWorld,
Comparable<Location> {
    public static final Location NULL = new Location(null, 0.0, 0.0, 0.0);

    public Location(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public Location(NBTTagCompound nbt) {
        this((World)DimensionManager.getWorld((int)nbt.func_74762_e("dimension")), nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"));
    }

    public Location(ByteBuf data) {
        this((World)DimensionManager.getWorld((int)data.readInt()), data.readDouble(), data.readDouble(), data.readDouble());
    }

    public Location(Entity entity) {
        this(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public Location(TileEntity tile) {
        super(tile);
    }

    public Location(IPosWorld vec) {
        this(vec.world(), vec.x(), vec.y(), vec.z());
    }

    public Location(ILocation loc) {
        this(loc.func_82618_k(), loc.func_82615_a(), loc.func_82617_b(), loc.func_82616_c());
    }

    public Location(World world, IPos3D vector) {
        this(world, vector.x(), vector.y(), vector.z());
    }

    public Location(World world, BlockPos pos) {
        this(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Location(World world, Vec3d vec) {
        this(world, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Location(World world, RayTraceResult target) {
        this(world, target.field_72307_f);
    }

    @Override
    public Location newPos(double x, double y, double z) {
        return new Location(this.world, x, y, z);
    }

    public void playSound(SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        this.world().func_184134_a(this.x(), this.y(), this.z(), soundIn, category, volume, pitch, distanceDelay);
    }

    public boolean isSideSolid(EnumFacing side) {
        IBlockState state = this.getBlockState((IBlockAccess)this.world);
        if (state != null && state.func_177230_c() != Blocks.field_150350_a) {
            BlockFaceShape shape = state.func_193401_d((IBlockAccess)this.world, this.toBlockPos(), side);
            return shape != null && shape == BlockFaceShape.SOLID;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Location && this.world == ((Location)o).world() && ((Location)o).x() == this.x() && ((Location)o).y() == this.y() && ((Location)o).z() == this.z();
    }

    @Override
    public int compareTo(Location that) {
        if (this.world().field_73011_w.getDimension() < that.world().field_73011_w.getDimension() || this.x() < that.x() || this.y() < that.y() || this.z() < that.z()) {
            return -1;
        }
        if (this.world().field_73011_w.getDimension() > that.world().field_73011_w.getDimension() || this.x() > that.x() || this.y() > that.y() || this.z() > that.z()) {
            return 1;
        }
        return 0;
    }
}

