/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.transform.vector;

import com.builtbroken.atomic.lib.transform.IPosWorld;
import com.builtbroken.atomic.lib.transform.vector.AbstractPos;
import com.builtbroken.atomic.lib.transform.vector.Pos;
import com.builtbroken.jlib.data.vector.IPos3D;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.ILocation;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;

public abstract class AbstractLocation<R extends AbstractLocation>
extends AbstractPos<R>
implements ILocation,
IPosWorld {
    public World world;

    public AbstractLocation(World world, double x, double y, double z) {
        super(x, y, z);
        this.world = world;
    }

    public AbstractLocation(World world, BlockPos pos) {
        super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        this.world = world;
    }

    public AbstractLocation(NBTTagCompound nbt) {
        this((World)DimensionManager.getWorld((int)nbt.func_74762_e("dimension")), nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"));
    }

    public AbstractLocation(ByteBuf data) {
        this((World)DimensionManager.getWorld((int)data.readInt()), data.readDouble(), data.readDouble(), data.readDouble());
    }

    public AbstractLocation(Entity entity) {
        this(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public AbstractLocation(TileEntity tile) {
        this(tile.func_145831_w(), tile.func_174877_v());
    }

    public AbstractLocation(IPosWorld vec) {
        this(vec.world(), vec.x(), vec.y(), vec.z());
    }

    public AbstractLocation(World world, IPos3D vector) {
        this(world, vector.x(), vector.y(), vector.z());
    }

    public AbstractLocation(World world, Vec3d vec) {
        this(world, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public AbstractLocation(World world, RayTraceResult target) {
        this(world, target.field_72307_f);
    }

    @Override
    public World world() {
        return this.world;
    }

    public World func_82618_k() {
        return this.world;
    }

    @Override
    public int dim() {
        return this.world.field_73011_w.getDimension();
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("dimension", this.world != null && this.world.field_73011_w != null ? this.world.field_73011_w.getDimension() : 0);
        nbt.func_74780_a("x", this.x());
        nbt.func_74780_a("y", this.y());
        nbt.func_74780_a("z", this.z());
        return nbt;
    }

    @Override
    public ByteBuf writeByteBuf(ByteBuf data) {
        data.writeInt(this.world != null && this.world.field_73011_w != null ? this.world.field_73011_w.getDimension() : 0);
        data.writeDouble(this.x());
        data.writeDouble(this.y());
        data.writeDouble(this.z());
        return data;
    }

    @Deprecated
    public Pos toVector3() {
        return new Pos(this.x(), this.y(), this.z());
    }

    @Override
    public Pos toPos() {
        return new Pos(this.x(), this.y(), this.z());
    }

    @Deprecated
    public Block getBlock() {
        if (this.world != null && this.world.func_175668_a(this.toBlockPos(), false)) {
            return super.getBlock((IBlockAccess)this.world);
        }
        return null;
    }

    public IBlockState getBlockState() {
        if (this.world != null && this.world.func_175668_a(this.toBlockPos(), false)) {
            return super.getBlockState((IBlockAccess)this.world);
        }
        return null;
    }

    public TileEntity getTileEntity() {
        if (this.world != null) {
            TileEntity tile = this.world.func_175625_s(this.toBlockPos());
            return tile == null || tile.func_145837_r() ? null : tile;
        }
        return null;
    }

    public float getHardness() {
        return super.getHardness(this.world);
    }

    public float getResistance(Entity cause, double xx, double yy, double zz) {
        return super.getResistance(this.world, cause, xx, yy, zz);
    }

    public boolean setBlock(IBlockState block, int notify) {
        return super.setBlock(this.world, block, notify);
    }

    public boolean setBlock(IBlockState state) {
        return super.setBlock(this.world, state, 3);
    }

    public boolean setBlock(Block block) {
        return super.setBlock(this.world, block);
    }

    public boolean setBlockToAir() {
        return super.setBlockToAir(this.world);
    }

    public boolean isAirBlock() {
        return super.isAirBlock(this.world);
    }

    public boolean isBlockEqual(Block block) {
        return super.isBlockEqual(this.world, block);
    }

    public boolean isBlockFreezable() {
        return super.isBlockFreezable(this.world);
    }

    public boolean isReplaceable() {
        return super.isReplaceable(this.world);
    }

    public boolean canSeeSky() {
        return super.canSeeSky(this.world);
    }

    public boolean isChunkLoaded() {
        if (this.world instanceof WorldServer) {
            return ((WorldServer)this.world).func_72863_F().func_73149_a(this.xi() >> 4, this.zi() >> 4) && this.getChunk().func_177410_o();
        }
        return this.world.func_72863_F().func_191062_e(this.xi() >> 4, this.zi() >> 4) && this.getChunk().func_177410_o();
    }

    public Chunk getChunk() {
        return this.world.func_175726_f(this.toBlockPos());
    }

    public void markForUpdate() {
        super.markForUpdate(this.world);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof AbstractLocation && this.world == ((AbstractLocation)o).world() && ((AbstractLocation)o).x() == this.x() && ((AbstractLocation)o).y() == this.y() && ((AbstractLocation)o).z() == this.z();
    }

    @Override
    public String toString() {
        return "WorldLocation [" + this.x() + "x," + this.y() + "y," + this.z() + "z," + (this.world == null ? "n" : (this.world.field_73011_w == null ? "p" : Integer.valueOf(this.world.field_73011_w.getDimension()))) + "d]";
    }
}

