/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.transform.move;

public class FractionAxis {
    private int wholeNumbers;
    private int numerator;
    private int denominator;

    public FractionAxis() {
    }

    public FractionAxis(int denominator) {
        this.denominator = denominator;
    }

    public void clear() {
        this.wholeNumbers = 0;
        this.numerator = 0;
    }

    public void set(double value) {
        this.clear();
        this.add(value);
    }

    public void add(double add) {
        if (add != 0.0) {
            int whole = (int)Math.floor(add);
            double remain = add - (double)whole;
            this.wholeNumbers += whole;
            this.numerator += (int)Math.round(remain * (double)this.getDenominator());
            if (this.getNumerator() >= this.getDenominator()) {
                ++this.wholeNumbers;
                this.numerator -= this.getDenominator();
            }
        }
    }

    public double get() {
        return (double)this.getWhole() + this.getDecimal();
    }

    public int getWhole() {
        return this.wholeNumbers;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public double getDecimal() {
        return (double)this.getNumerator() / (double)this.getDenominator();
    }

    public void setPrecision(int precision) {
        if (precision != this.denominator) {
            if (this.numerator != 0) {
                double number = this.getDecimal();
                this.numerator = (int)Math.round(number * (double)precision);
            }
            this.denominator = precision;
        }
    }
}

