/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.timer;

import com.builtbroken.atomic.lib.timer.ITickTimer;
import java.util.function.BooleanSupplier;
import java.util.function.IntConsumer;
import net.minecraft.tileentity.TileEntity;

public class TickTimerTileEntity
implements ITickTimer<TileEntity> {
    protected final int triggerTime;
    protected final IntConsumer function;
    protected final BooleanSupplier shouldRun;

    protected TickTimerTileEntity(int triggerTime, IntConsumer consumer, BooleanSupplier shouldRun) {
        this.triggerTime = triggerTime;
        this.function = consumer;
        this.shouldRun = shouldRun;
    }

    public static TickTimerTileEntity newSimple(int triggerTime, IntConsumer consumer) {
        return new TickTimerTileEntity(triggerTime, consumer, () -> true);
    }

    public static TickTimerTileEntity newSimple(IntConsumer consumer) {
        return new TickTimerTileEntity(0, consumer, () -> true);
    }

    public static TickTimerTileEntity newConditional(int triggerTime, IntConsumer consumer, BooleanSupplier shouldRun) {
        return new TickTimerTileEntity(triggerTime, consumer, shouldRun);
    }

    @Override
    public void tick(TileEntity host, int systemTick) {
        if (this.shouldRun.getAsBoolean() && (this.triggerTime <= 0 || systemTick % this.triggerTime == 0)) {
            this.function.accept(systemTick);
        }
    }
}

