/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.timer;

import com.builtbroken.atomic.lib.timer.TickTimer;
import com.builtbroken.atomic.lib.timer.TimeEndFunction;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;

public class TickTimerConditional
extends TickTimer {
    protected Optional<BooleanSupplier> shouldTickFunction;
    protected Optional<BooleanSupplier> shouldResetFunction;

    public TickTimerConditional(int triggerTime, TimeEndFunction function) {
        super(triggerTime, function);
    }

    public TickTimerConditional(IntSupplier triggerTime, TimeEndFunction function) {
        super(triggerTime, function);
    }

    public TickTimerConditional(int triggerTime, IntConsumer consumer) {
        super(triggerTime, consumer);
    }

    public TickTimerConditional(IntSupplier triggerTime, IntConsumer consumer) {
        super(triggerTime, consumer);
    }

    public static TickTimerConditional newSimple(int triggerTime, IntConsumer consumer) {
        return new TickTimerConditional(triggerTime, consumer);
    }

    public static TickTimerConditional newSimple(IntSupplier triggerTime, IntConsumer consumer) {
        return new TickTimerConditional(triggerTime, consumer);
    }

    public static TickTimerConditional newTrigger(IntConsumer consumer, BooleanSupplier triggerCondition) {
        return new TickTimerConditional(1, consumer).setShouldTickFunction(triggerCondition).setShouldResetFunction(() -> !triggerCondition.getAsBoolean());
    }

    public static TickTimerConditional newTrigger(IntSupplier triggerTime, IntConsumer consumer, BooleanSupplier triggerCondition) {
        return new TickTimerConditional(triggerTime, consumer).setShouldTickFunction(triggerCondition).setShouldResetFunction(() -> !triggerCondition.getAsBoolean());
    }

    public static TickTimerConditional newTrigger(int triggerTime, IntConsumer consumer, BooleanSupplier triggerCondition) {
        return new TickTimerConditional(triggerTime, consumer).setShouldTickFunction(triggerCondition).setShouldResetFunction(() -> !triggerCondition.getAsBoolean());
    }

    @Override
    public void tick() {
        if (this.shouldTickFunction == null || this.shouldTickFunction.orElse(() -> true).getAsBoolean()) {
            super.tick();
        }
        if (this.shouldResetFunction != null && this.shouldResetFunction.orElse(() -> true).getAsBoolean()) {
            this.ticks = 0;
        }
    }

    public TickTimerConditional setShouldTickFunction(BooleanSupplier shouldTickFunction) {
        this.shouldTickFunction = Optional.of(shouldTickFunction);
        return this;
    }

    public TickTimerConditional setShouldResetFunction(BooleanSupplier shouldResetFunction) {
        this.shouldResetFunction = Optional.of(shouldResetFunction);
        return this;
    }

    public TickTimerConditional setTickAndRefreshFunction(BooleanSupplier function) {
        this.shouldResetFunction = Optional.of(function);
        this.shouldTickFunction = Optional.of(function);
        return this;
    }
}

