/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.timer;

import com.builtbroken.atomic.lib.timer.ITickTimer;
import com.builtbroken.atomic.lib.timer.TimeEndFunction;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;

public class TickTimer
implements ITickTimer {
    protected final IntSupplier triggerTime;
    protected final TimeEndFunction function;
    protected int ticks = 0;

    protected TickTimer(IntSupplier triggerTime, TimeEndFunction function) {
        this.triggerTime = triggerTime;
        this.function = function;
    }

    protected TickTimer(int triggerTime, TimeEndFunction function) {
        this(() -> triggerTime, function);
    }

    protected TickTimer(int triggerTime, IntConsumer consumer) {
        this.triggerTime = () -> triggerTime;
        this.function = ticks -> {
            consumer.accept(ticks);
            return true;
        };
    }

    protected TickTimer(IntSupplier triggerTime, IntConsumer consumer) {
        this.triggerTime = triggerTime;
        this.function = ticks -> {
            consumer.accept(ticks);
            return true;
        };
    }

    public static TickTimer newSimple(int triggerTime, IntConsumer consumer) {
        return new TickTimer(triggerTime, consumer);
    }

    public void tick() {
        ++this.ticks;
        if (this.ticks % this.triggerTime.getAsInt() == 0 && (this.function.trigger(this.ticks) || this.ticks >= 0x7FFFFFFD)) {
            this.ticks = 0;
        }
    }

    public void tick(Object host, int systemTick) {
        this.tick();
    }
}

