/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.thermal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.IntSupplier;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

public class ThermalHandler {
    public static final BlockDataMap<HeatCalc> heatMoveRate = new BlockDataMap<HeatCalc>((block, heat) -> heat * 5 / 100);
    public static final BlockDataMap<IntSupplier> heatCapacity = new BlockDataMap<IntSupplier>(() -> 100);
    public static final BlockDataMap<IntSupplier> heatLossFlat = new BlockDataMap<IntSupplier>(() -> 10);
    public static final BlockDataMap<HeatCalc> heatLossPercentage = new BlockDataMap<HeatCalc>((block, heat) -> 0);

    public static void init() {
        ThermalHandler.setHeatMoveRate(Material.field_151573_f, 40, 400, 2);
        ThermalHandler.setHeatMoveRate(Blocks.field_150340_R, 50, 400, 1);
        ThermalHandler.setHeatMoveRate((Block)Blocks.field_150355_j, 20, 1000, 0);
        ThermalHandler.setHeatMoveRate((Block)Blocks.field_150358_i, 20, 1000, 0);
        ThermalHandler.setHeatMoveRate(Blocks.field_150357_h, 0, 0, Integer.MAX_VALUE);
        ThermalHandler.setHeatMoveRate(Blocks.field_180401_cv, 0, 0, Integer.MAX_VALUE);
    }

    public static void setHeatMoveRate(Block block, int give, int cap, int loss) {
        heatMoveRate.add(block, (bs, heat) -> give * heat / 100);
        heatCapacity.add(block, () -> cap);
        heatLossFlat.add(block, () -> loss);
    }

    public static void setHeatMoveRate(Material material, int give, int cap, int loss) {
        heatMoveRate.add(material, (bs, heat) -> give * heat / 100);
        heatCapacity.add(material, () -> cap);
        heatLossFlat.add(material, () -> loss);
    }

    public static int getHeatLost(IBlockState state, int heat) {
        return heatLossFlat.get(state).getAsInt() + heatLossPercentage.get(state).calc(state, heat);
    }

    public static int getBlockCapacity(IBlockState state) {
        return heatCapacity.get(state).getAsInt();
    }

    public static float getTransferRate(IBlockState state) {
        return heatMoveRate.get(state).calc(state, -1);
    }

    public static int getHeatMoved(IBlockState state, int heat) {
        return heatMoveRate.get(state).calc(state, heat);
    }

    private static interface HeatCalc {
        public int calc(IBlockState var1, int var2);
    }

    private static class BlockDataMap<A> {
        private final Map<Material, A> materials = new HashMap<Material, A>();
        private final Map<Block, A> blocks = new HashMap<Block, A>();
        private final A defaultValue;

        public BlockDataMap(A defaultValue) {
            this.defaultValue = defaultValue;
        }

        public A get(IBlockState state) {
            return this.blocks.getOrDefault(state.func_177230_c(), this.materials.getOrDefault(state.func_185904_a(), this.defaultValue));
        }

        public void add(Block block, A value) {
            this.blocks.put(block, value);
        }

        public void add(Material material, A value) {
            this.materials.put(material, value);
        }
    }
}

