/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.recipe;

import com.builtbroken.atomic.AtomicScience;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class IngredientFirstMatch
implements IIngredientFactory {
    @Nonnull
    public Ingredient parse(JsonContext context, JsonObject json) {
        JsonArray array = JsonUtils.func_151214_t((JsonObject)json, (String)"items");
        for (JsonElement element : array) {
            Ingredient ingredient = this.get(context, element);
            if (ingredient == null) continue;
            for (ItemStack stack : ingredient.func_193365_a()) {
                if (stack == null || stack.func_190926_b()) continue;
                return ingredient;
            }
        }
        AtomicScience.logger.error("IngredientBackup: Failed to match any items to existing items, setting slot to empty. " + json);
        return Ingredient.field_193370_a;
    }

    Ingredient get(JsonContext context, JsonElement element) {
        if (element.isJsonPrimitive()) {
            return this.get(element.getAsString());
        }
        return CraftingHelper.getIngredient((JsonElement)element, (JsonContext)context);
    }

    Ingredient get(String key) {
        if (key.startsWith("ore:")) {
            String name = key.substring(4);
            NonNullList list = OreDictionary.getOres((String)name);
            for (ItemStack stack : list) {
                if (stack.func_190926_b()) continue;
                return new OreIngredient(name);
            }
            return null;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(key));
        return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(item)});
    }
}

