/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.radiation;

import com.builtbroken.atomic.api.AtomicScienceAPI;
import com.builtbroken.atomic.api.radiation.IRadiationResistant;
import com.builtbroken.atomic.config.logic.ConfigRadiation;
import com.builtbroken.atomic.content.effects.effects.FloatSupplier;
import com.builtbroken.atomic.lib.radiation.RadiationResistanceSupplier;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RadiationHandler {
    public static final HashMap<IBlockState, RadiationResistanceSupplier> blockStateToRadiationPercentage = new HashMap();
    public static final HashMap<Block, RadiationResistanceSupplier> blockToRadiationPercentage = new HashMap();
    public static final HashMap<Material, FloatSupplier> materialToRadiationPercentage = new HashMap();

    public static void init() {
        RadiationHandler.setValue(Material.field_151576_e, () -> ConfigRadiation.RADIATION_DECAY_STONE);
        RadiationHandler.setValue(Material.field_76233_E, () -> ConfigRadiation.RADIATION_DECAY_STONE);
        RadiationHandler.setValue(Material.field_151578_c, () -> ConfigRadiation.RADIATION_DECAY_STONE / 2.0f);
        RadiationHandler.setValue(Material.field_151577_b, () -> ConfigRadiation.RADIATION_DECAY_STONE / 2.0f);
        RadiationHandler.setValue(Material.field_151595_p, () -> ConfigRadiation.RADIATION_DECAY_STONE / 2.0f);
        RadiationHandler.setValue(Material.field_151571_B, () -> ConfigRadiation.RADIATION_DECAY_STONE / 2.0f);
        RadiationHandler.setValue(Material.field_151588_w, () -> ConfigRadiation.RADIATION_DECAY_STONE / 3.0f);
        RadiationHandler.setValue(Material.field_151598_x, () -> ConfigRadiation.RADIATION_DECAY_STONE / 3.0f);
        RadiationHandler.setValue(Material.field_151596_z, () -> ConfigRadiation.RADIATION_DECAY_STONE / 3.0f);
        RadiationHandler.setValue(Material.field_151573_f, () -> ConfigRadiation.RADIATION_DECAY_METAL);
        RadiationHandler.setValue(Blocks.field_150336_V, (World world, BlockPos pos, IBlockState state) -> ConfigRadiation.RADIATION_DECAY_STONE * 1.2f);
        RadiationHandler.setValue(Blocks.field_150385_bj, (World world, BlockPos pos, IBlockState state) -> ConfigRadiation.RADIATION_DECAY_STONE * 1.2f);
        RadiationHandler.setValue(Blocks.field_150417_aV, (World world, BlockPos pos, IBlockState state) -> ConfigRadiation.RADIATION_DECAY_STONE * 1.1f);
        RadiationHandler.setValue(Blocks.field_150371_ca, (World world, BlockPos pos, IBlockState state) -> ConfigRadiation.RADIATION_DECAY_STONE * 1.4f);
        RadiationHandler.setValue(Blocks.field_150484_ah, (World world, BlockPos pos, IBlockState state) -> ConfigRadiation.RADIATION_DECAY_STONE * 2.0f);
        RadiationHandler.setValue(Blocks.field_150340_R, (World world, BlockPos pos, IBlockState state) -> ConfigRadiation.RADIATION_DECAY_STONE * 1.3f);
        RadiationHandler.setValue(Blocks.field_150343_Z, (World world, BlockPos pos, IBlockState state) -> ConfigRadiation.RADIATION_DECAY_STONE * 1.5f);
        RadiationHandler.setValue(Blocks.field_150347_e, (World world, BlockPos pos, IBlockState state) -> ConfigRadiation.RADIATION_DECAY_STONE * 0.7f);
        RadiationHandler.setValue(Blocks.field_150341_Y, (World world, BlockPos pos, IBlockState state) -> ConfigRadiation.RADIATION_DECAY_STONE * 0.8f);
        RadiationHandler.setValue((Block)Blocks.field_150454_av, (World world, BlockPos pos, IBlockState state) -> ConfigRadiation.RADIATION_DECAY_METAL / 3.0f);
        RadiationHandler.setValue(Blocks.field_150411_aY, (World world, BlockPos pos, IBlockState state) -> ConfigRadiation.RADIATION_DECAY_METAL / 4.0f);
        RadiationHandler.setValue(Blocks.field_192443_dR, (World world, BlockPos pos, IBlockState state) -> ConfigRadiation.RADIATION_DECAY_METAL * 2.0f);
    }

    public static void setValue(Block block, RadiationResistanceSupplier supplier) {
        blockToRadiationPercentage.put(block, supplier);
    }

    public static void setValue(IBlockState blockState, RadiationResistanceSupplier supplier) {
        blockStateToRadiationPercentage.put(blockState, supplier);
    }

    public static void setValue(Material material, FloatSupplier supplier) {
        materialToRadiationPercentage.put(material, supplier);
    }

    public static float getReduceRadiationForBlock(World world, int xi, int yi, int zi) {
        BlockPos pos = new BlockPos(xi, yi, zi);
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.hasCapability(AtomicScienceAPI.RADIATION_RESISTANT_CAPABILITY, null)) {
            IRadiationResistant radiationResistant = (IRadiationResistant)tileEntity.getCapability(AtomicScienceAPI.RADIATION_RESISTANT_CAPABILITY, null);
            if (radiationResistant != null) {
                return radiationResistant.getRadiationResistance();
            }
        } else {
            if (blockStateToRadiationPercentage.containsKey(blockState)) {
                return blockStateToRadiationPercentage.get(blockState).getAsFloat(world, pos, blockState);
            }
            if (blockToRadiationPercentage.containsKey(block)) {
                return blockToRadiationPercentage.get(block).getAsFloat(world, pos, blockState);
            }
            if (!block.isAir(blockState, (IBlockAccess)world, pos)) {
                if (blockState.func_185904_a().func_76220_a()) {
                    if (blockState.func_185914_p()) {
                        Material material = blockState.func_185904_a();
                        if (materialToRadiationPercentage.containsKey(material)) {
                            return materialToRadiationPercentage.get(material).getAsFloat();
                        }
                        return ConfigRadiation.RADIATION_DECAY_PER_BLOCK;
                    }
                    return ConfigRadiation.RADIATION_DECAY_PER_BLOCK / 2.0f;
                }
                if (blockState.func_185904_a().func_76224_d()) {
                    return ConfigRadiation.RADIATION_DECAY_PER_FLUID;
                }
            }
        }
        return 0.0f;
    }

    public static double reduceRadiationForBlock(World world, int xi, int yi, int zi, double power) {
        float reduction = RadiationHandler.getReduceRadiationForBlock(world, xi, yi, zi);
        if (power < (double)(reduction * 1000.0f)) {
            return 0.0;
        }
        power -= power * (double)reduction;
        return power;
    }

    public static int getRadFromMaterial(int material_amount) {
        return (int)Math.ceil((float)material_amount * ConfigRadiation.MAP_VALUE_TO_MILI_RAD);
    }

    public static double getRadForDistance(double power, double distanceSQ) {
        return RadiationHandler.getRadForDistance(power, 1.0, distanceSQ);
    }

    public static double getRadForDistance(double power, double distanceSourceSQ, double distanceSQ) {
        if (distanceSQ < distanceSourceSQ) {
            return power;
        }
        return power * distanceSourceSQ / distanceSQ;
    }

    public static double getDecayRange(int power) {
        return Math.sqrt((double)power + 2.0);
    }
}

