/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.power;

import com.builtbroken.atomic.lib.power.PowerHandler;
import com.builtbroken.atomic.lib.power.PowerHandlerFE;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PowerSystem {
    private static final List<PowerHandler> powerHandlers = new ArrayList<PowerHandler>();

    public static void register(PowerHandler powerHandler) {
        if (powerHandler != null) {
            powerHandlers.add(powerHandler);
        }
    }

    public static boolean canSupport(EnumFacing sideToAccess, TileEntity tileEntity) {
        return PowerSystem.getHandler(sideToAccess, tileEntity) != null;
    }

    public static PowerHandler getHandler(EnumFacing sideToAccess, TileEntity tileEntity) {
        for (PowerHandler handler : powerHandlers) {
            if (!handler.canHandle(sideToAccess, tileEntity)) continue;
            return handler;
        }
        return null;
    }

    public static PowerHandler getHandler(ItemStack stack) {
        if (stack != null && stack.func_77973_b() != null) {
            for (PowerHandler handler : powerHandlers) {
                if (!handler.canHandle(stack)) continue;
                return handler;
            }
        }
        return null;
    }

    public static int addPower(EnumFacing sideAccessed, TileEntity tileEntity, int power, boolean doAction) {
        PowerHandler handler;
        if (power > 0 && (handler = PowerSystem.getHandler(sideAccessed, tileEntity)) != null) {
            return handler.addPower(sideAccessed, tileEntity, power, doAction);
        }
        return 0;
    }

    public static int outputPower(TileEntity tile, EnumFacing direction, int powerToOutput, boolean doAction) {
        return PowerSystem.outputPower(tile.func_145831_w(), tile.func_174877_v(), direction, powerToOutput, doAction);
    }

    public static int outputPower(World world, BlockPos pos, EnumFacing direction, int powerToOutput, boolean doAction) {
        TileEntity tile;
        if (powerToOutput > 0 && (tile = world.func_175625_s(pos = pos.func_177971_a(direction.func_176730_m()))) != null) {
            return PowerSystem.addPower(direction.func_176734_d(), tile, powerToOutput, doAction);
        }
        return 0;
    }

    public static int dischargeItem(ItemStack itemStack, int amount, boolean doAction) {
        PowerHandler handler;
        if (amount > 0 && (handler = PowerSystem.getHandler(itemStack)) != null) {
            return handler.dischargeItem(itemStack, amount, doAction);
        }
        return 0;
    }

    public static int chargeItem(ItemStack itemStack, int amount, boolean doAction) {
        PowerHandler handler;
        if (amount > 0 && (handler = PowerSystem.getHandler(itemStack)) != null) {
            return handler.chargeItem(itemStack, amount, doAction);
        }
        return 0;
    }

    public static int getEnergyStored(ItemStack itemStack) {
        PowerHandler handler = PowerSystem.getHandler(itemStack);
        if (handler != null) {
            return handler.getItemPower(itemStack);
        }
        return 0;
    }

    public static int getMaxEnergyStored(ItemStack itemStack) {
        PowerHandler handler = PowerSystem.getHandler(itemStack);
        if (handler != null) {
            return handler.getItemMaxPower(itemStack);
        }
        return 0;
    }

    public static void forEach(Consumer<PowerHandler> action) {
        powerHandlers.forEach(action);
    }

    static {
        PowerSystem.register(new PowerHandlerFE());
    }
}

