/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.power;

import com.builtbroken.atomic.lib.power.PowerHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class PowerHandlerFE
extends PowerHandler {
    @Override
    public boolean canHandle(EnumFacing side, TileEntity tile) {
        return tile.hasCapability(CapabilityEnergy.ENERGY, side);
    }

    @Override
    public int addPower(EnumFacing side, TileEntity tile, int power, boolean doAction) {
        IEnergyStorage storage;
        if (tile.hasCapability(CapabilityEnergy.ENERGY, side) && (storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side)) != null) {
            return storage.receiveEnergy(power, !doAction);
        }
        return 0;
    }

    @Override
    public int removePower(EnumFacing side, TileEntity tile, int power, boolean doAction) {
        IEnergyStorage storage;
        if (tile.hasCapability(CapabilityEnergy.ENERGY, side) && (storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side)) != null) {
            return storage.extractEnergy(power, !doAction);
        }
        return 0;
    }

    @Override
    public boolean canHandle(ItemStack stack) {
        return stack.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    @Override
    public int chargeItem(ItemStack stack, int power, boolean doAction) {
        return 0;
    }

    @Override
    public int dischargeItem(ItemStack stack, int power, boolean doAction) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return storage.extractEnergy(power, !doAction);
        }
        return 0;
    }

    @Override
    public int getItemPower(ItemStack stack) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return storage.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getItemMaxPower(ItemStack stack) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return storage.getMaxEnergyStored();
        }
        return 0;
    }
}

