/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.power;

import java.util.function.IntSupplier;
import net.minecraftforge.energy.IEnergyStorage;

public class Battery
implements IEnergyStorage {
    protected int energy;
    protected IntSupplier capacityFunction;

    public Battery(int capacity) {
        this.capacityFunction = () -> capacity;
    }

    public Battery(IntSupplier capacityFunction) {
        this.capacityFunction = capacityFunction;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int prev_energy = this.energy;
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.energy, Math.min(this.getReceiveLimit(), maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        if (simulate && prev_energy != this.energy) {
            this.onEnergyChanged(prev_energy, this.energy);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int prev_energy = this.energy;
        int energyExtracted = Math.min(this.energy, Math.min(this.getExtractLimit(), maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        if (simulate && prev_energy != this.energy) {
            this.onEnergyChanged(prev_energy, this.energy);
        }
        return energyExtracted;
    }

    protected void onEnergyChanged(int prev, int current) {
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacityFunction.getAsInt();
    }

    public boolean canExtract() {
        return this.getExtractLimit() > 0;
    }

    public boolean canReceive() {
        return this.getReceiveLimit() > 0;
    }

    public int getExtractLimit() {
        return this.getMaxEnergyStored();
    }

    public int getReceiveLimit() {
        return this.getMaxEnergyStored();
    }
}

