/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.placement;

import com.builtbroken.atomic.lib.placement.BlockPlacement;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlacementQueue {
    private static final ConcurrentLinkedQueue<BlockPlacement> queue = new ConcurrentLinkedQueue();

    public static void queue(World world, BlockPos pos, IBlockState state) {
        PlacementQueue.queue(new BlockPlacement(world, pos, state));
    }

    public static void queue(BlockPlacement placement) {
        if (placement != null && placement.blockState != null) {
            queue.add(placement);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            long time = System.currentTimeMillis();
            LinkedList<BlockPlacement> delayList = new LinkedList<BlockPlacement>();
            while (!queue.isEmpty() && System.currentTimeMillis() - time < 10L) {
                BlockPlacement placement = queue.poll();
                if (placement == null || placement.doPlacement()) continue;
                delayList.add(placement);
            }
            queue.addAll(delayList);
        }
    }
}

