/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.placement;

import com.builtbroken.atomic.AtomicScience;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class BlockPlacement {
    public int dim;
    public BlockPos pos;
    public IBlockState blockState;
    public int placementDelay = 0;

    public BlockPlacement(World world, BlockPos pos, IBlockState block) {
        this.dim = world.field_73011_w.getDimension();
        this.pos = pos;
        this.blockState = block;
    }

    public BlockPlacement delay(int ticks) {
        this.placementDelay = ticks;
        return this;
    }

    public boolean doPlacement() {
        if (this.placementDelay-- > 0) {
            return false;
        }
        try {
            if (this.canDoAction()) {
                World world = this.world();
                if (world != null) {
                    if (world.func_180501_a(this.pos, this.blockState, 3)) {
                        this.onPlacedBlock();
                    } else {
                        AtomicScience.logger.error("PlacementQueue: Failed to place block in world. " + this);
                    }
                } else {
                    AtomicScience.logger.error("PlacementQueue: Failed to get world for placement. " + this);
                }
            }
        }
        catch (Exception e) {
            AtomicScience.logger.error("PlacementQueue: Unexpected error placing block. " + this, (Throwable)e);
        }
        return true;
    }

    protected void onPlacedBlock() {
    }

    protected boolean canDoAction() {
        return true;
    }

    public World world() {
        return DimensionManager.getWorld((int)this.dim);
    }

    public String toString() {
        return "BlockPlacement[" + this.dim + " | " + this.pos + " | " + this.blockState + "]";
    }
}

