/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.oregen;

import com.builtbroken.atomic.lib.oregen.OreGenerator;
import com.builtbroken.atomic.lib.oregen.OreGeneratorSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.IChunkGenerator;

public class OreGenReplace
extends OreGenerator {
    public final OreGeneratorSettings settings;
    public boolean ignoreSurface = false;
    public boolean ignoreNether = true;
    public boolean ignoreEnd = true;

    public OreGenReplace(IBlockState block, OreGeneratorSettings settings, String harvestTool, int harvestLevel) {
        super(block, harvestTool, harvestLevel);
        this.settings = settings;
    }

    @Override
    public void generate(World world, Random random, int varX, int varZ, int chunkPosX, int chunkPosZ) {
        int placed;
        for (int blocksPlaced = 0; blocksPlaced < this.settings.amountPerChunk; blocksPlaced += placed) {
            int x = varX + 4 + random.nextInt(7);
            int z = varZ + 4 + random.nextInt(7);
            int y = random.nextInt(Math.max(this.settings.maxGenerateLevel - this.settings.minGenerateLevel, 0)) + this.settings.minGenerateLevel;
            placed = this.generateBranch(world, random, varX, varZ, x, y, z, chunkPosX, chunkPosZ);
            if (placed > 0) continue;
            placed = this.settings.amountPerBranch;
        }
    }

    public int generateBranch(World world, Random rand, int chunkCornerX, int chunkCornerZ, int varX, int varY, int varZ, int chunkPosX, int chunkPosZ) {
        int min_y = Math.max(0, this.settings.minGenerateLevel);
        int max_y = Math.min(world.func_72800_K(), this.settings.maxGenerateLevel);
        BlockPos start = new BlockPos(varX, varY, varZ);
        int blocksPlaced = 0;
        ArrayList<BlockPos> pathed = new ArrayList<BlockPos>();
        LinkedList<BlockPos> toPath = new LinkedList<BlockPos>();
        toPath.add(start);
        ArrayList<EnumFacing> directions = new ArrayList<EnumFacing>();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            directions.add(dir);
        }
        while (!toPath.isEmpty() && blocksPlaced < this.settings.amountPerBranch) {
            BlockPos currentPathPosition = (BlockPos)toPath.poll();
            pathed.add(currentPathPosition);
            if (!world.func_175667_e(currentPathPosition)) continue;
            IBlockState blockState = world.func_180495_p(currentPathPosition);
            Block block = blockState.func_177230_c();
            if ((this.settings.replaceBlock == null || block == this.settings.replaceBlock) && world.func_180501_a(currentPathPosition, this.oreBlock, 2)) {
                ++blocksPlaced;
            }
            Collections.shuffle(directions);
            for (EnumFacing direction : directions) {
                BlockPos nextPathPosition = currentPathPosition.func_177971_a(direction.func_176730_m());
                if (pathed.contains(nextPathPosition) || !rand.nextBoolean()) continue;
                if (nextPathPosition.func_177958_n() >> 4 == chunkPosX && nextPathPosition.func_177952_p() >> 4 == chunkPosZ && nextPathPosition.func_177956_o() >= min_y && nextPathPosition.func_177956_o() < max_y && world.func_175667_e(nextPathPosition) && nextPathPosition.func_177958_n() % 16 != 15 && nextPathPosition.func_177952_p() % 16 != 15 && nextPathPosition.func_177958_n() % 16 != 0 && nextPathPosition.func_177952_p() % 16 != 0) {
                    blockState = world.func_180495_p(nextPathPosition);
                    block = blockState.func_177230_c();
                    if (this.settings.replaceBlock == null || block == this.settings.replaceBlock) {
                        toPath.add(nextPathPosition);
                    }
                }
                if (toPath.contains(nextPathPosition)) continue;
                pathed.add(nextPathPosition);
            }
        }
        return blocksPlaced;
    }

    @Override
    public boolean isOreGeneratedInWorld(World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (this.ignoreSurface && chunkGenerator instanceof ChunkGeneratorOverworld) {
            return false;
        }
        if (this.ignoreNether && chunkGenerator instanceof ChunkGeneratorHell) {
            return false;
        }
        return !this.ignoreEnd || !(chunkGenerator instanceof ChunkGeneratorEnd);
    }
}

