/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.math;

import net.minecraft.util.EnumFacing;

public class SideMathHelper {
    public static float getEdge(EnumFacing facing) {
        switch (facing) {
            case UP: {
                return 1.0f;
            }
            case DOWN: {
                return 0.0f;
            }
            case NORTH: {
                return 0.0f;
            }
            case SOUTH: {
                return 1.0f;
            }
            case EAST: {
                return 1.0f;
            }
            case WEST: {
                return 0.0f;
            }
        }
        return 0.5f;
    }

    public static float getEdgeOrCenterX(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return 1.0f;
            }
            case WEST: {
                return 0.0f;
            }
        }
        return 0.5f;
    }

    public static float getEdgeOrCenterZ(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 0.0f;
            }
            case SOUTH: {
                return 1.0f;
            }
        }
        return 0.5f;
    }

    public static float getEdgeOrCenterY(EnumFacing facing) {
        switch (facing) {
            case UP: {
                return 1.0f;
            }
            case DOWN: {
                return 0.0f;
            }
        }
        return 0.5f;
    }

    public static float remainingDistanceToSide(float deltaX, float deltaZ, EnumFacing direction) {
        switch (direction) {
            case NORTH: {
                return Math.max(0.0f, 0.5f + deltaZ);
            }
            case EAST: {
                return Math.max(0.0f, 0.5f - deltaX);
            }
            case SOUTH: {
                return Math.max(0.0f, 0.5f - deltaZ);
            }
            case WEST: {
                return Math.max(0.0f, 0.5f + deltaX);
            }
        }
        return 0.0f;
    }

    public static float remainingDistanceCenter(float deltaX, float deltaZ, EnumFacing direction) {
        float delta;
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                delta = deltaZ;
                break;
            }
            case EAST: 
            case WEST: {
                delta = deltaX;
                break;
            }
            default: {
                delta = 0.0f;
            }
        }
        return Math.abs(delta);
    }

    public static boolean isZero(float delta) {
        return delta <= 0.001f && delta >= -0.001f;
    }

    public static boolean isZero(float deltaX, float deltaY, float deltaZ) {
        return SideMathHelper.isZero(deltaX) && SideMathHelper.isZero(deltaY) && SideMathHelper.isZero(deltaZ);
    }

    public static EnumFacing containingSide(float deltaX, float deltaY, float deltaZ) {
        boolean zeroX = SideMathHelper.isZero(deltaX);
        boolean zeroY = SideMathHelper.isZero(deltaY);
        boolean zeroZ = SideMathHelper.isZero(deltaZ);
        if (!(zeroX || zeroY || zeroZ)) {
            return null;
        }
        if (!zeroZ) {
            return deltaZ > 0.0f ? EnumFacing.SOUTH : EnumFacing.NORTH;
        }
        if (!zeroX) {
            return deltaX > 0.0f ? EnumFacing.EAST : EnumFacing.WEST;
        }
        if (!zeroY) {
            return deltaY > 0.0f ? EnumFacing.UP : EnumFacing.DOWN;
        }
        return null;
    }
}

