/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.gui;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.lib.gui.ISlotRender;
import com.builtbroken.atomic.lib.gui.tip.ISlotToolTip;
import com.builtbroken.atomic.lib.gui.tip.ToolTip;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.input.Keyboard;

public class GuiContainerBase<H>
extends GuiContainer {
    public static final String TOOLTIP_TANK = "gui.tank.tooltip";
    public static final ResourceLocation GUI_COMPONENTS = new ResourceLocation("atomicscience", "textures/gui/gui_components.png");
    public static final ResourceLocation GUI_MC_BASE = new ResourceLocation("atomicscience", "textures/gui/mc_base.png");
    public ResourceLocation baseTexture;
    public ToolTip currentToolTip = null;
    protected List<ToolTip> tooltips = new ArrayList<ToolTip>();
    protected ArrayList<GuiTextField> fields = new ArrayList();
    protected int meterHeight = 49;
    protected int meterWidth = 14;
    public boolean renderSlotDebugIDs = false;
    protected H host;
    public boolean renderToolTips = true;
    public boolean renderTextFields = true;
    public boolean renderSlots = true;
    public boolean renderFluidTanks = true;
    public boolean traceSlotDraw = false;

    public GuiContainerBase(Container container, H host) {
        super(container);
        this.baseTexture = GUI_MC_BASE;
        this.host = host;
        if (AtomicScience.runningAsDev) {
            System.out.println("NEW: Container has " + container.field_75151_b.size() + " slots");
        }
    }

    public void func_73866_w_() {
        if (AtomicScience.runningAsDev) {
            System.out.println("InitGUI: Container has " + this.field_147002_h.field_75151_b.size() + " slots");
        }
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.fields.clear();
        this.tooltips.clear();
        this.field_147002_h.field_75151_b.stream().forEach(s -> {
            ToolTip toolTip;
            if (s instanceof ISlotToolTip && (toolTip = ((ISlotToolTip)s).getToolTip()) != null) {
                this.tooltips.add(toolTip);
            }
        });
    }

    protected <E extends GuiButton> E func_189646_b(E button) {
        this.field_146292_n.add(button);
        return button;
    }

    protected void addToolTip(int x, int y, int w, int h, String text, boolean translate) {
        this.addToolTip(new Rectangle(x, y, w, h), text, translate);
    }

    protected void addToolTip(Rectangle triggerArea, String text, boolean translate) {
        this.addToolTip(new ToolTip(triggerArea, text, translate));
    }

    protected void addToolTip(ToolTip toolTip) {
        this.tooltips.add(toolTip);
    }

    protected void drawString(String str, int x, int y, int color) {
        this.field_146289_q.func_78276_b(str, x, y, color);
    }

    protected void drawString(String str, int x, int y) {
        this.drawString(str, x, y, 0x404040);
    }

    protected void drawString(String str, int x, int y, Color color) {
        this.drawString(str, x, y, color.getRGB());
    }

    protected void drawStringCentered(String str, int x, int y) {
        this.drawStringCentered(str, x, y, 0x404040);
    }

    protected void drawStringCentered(String str, int x, int y, Color color) {
        this.drawStringCentered(str, x, y, color.getRGB());
    }

    protected void drawStringCentered(String str, int x, int y, int color) {
        this.drawString(str, x - this.field_146289_q.func_78256_a(str) / 2, y, color);
    }

    protected GuiTextField newField(int x, int y, int w, String msg) {
        return this.newField(x, y, w, 20, msg);
    }

    protected GuiTextField newField(int x, int y, int w, int h, String msg) {
        GuiTextField x_field = new GuiTextField(0, this.field_146289_q, x, y, w, h);
        x_field.func_146180_a("" + msg);
        x_field.func_146203_f(15);
        x_field.func_146193_g(0xFFFFFF);
        this.fields.add(x_field);
        return x_field;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
    }

    public void func_73863_a(int mouseX, int mouseY, float p_73863_3_) {
        super.func_73863_a(mouseX, mouseY, p_73863_3_);
        if (this.renderTextFields && this.fields != null && this.fields.size() > 0) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179084_k();
            for (GuiTextField field : this.fields) {
                field.func_146194_f();
            }
        }
        if (this.renderToolTips) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            for (ToolTip toolTip : this.tooltips) {
                if (!toolTip.isInArea(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
                this.currentToolTip = toolTip;
                break;
            }
            if (this.currentToolTip != null && this.currentToolTip.shouldShow()) {
                this.drawTooltip(mouseX, mouseY, this.currentToolTip.getString().split(";"));
            }
            this.currentToolTip = null;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().func_75211_c().func_190926_b()) {
                this.func_146285_a(this.getSlotUnderMouse().func_75211_c(), mouseX, mouseY);
            }
            GlStateManager.func_179121_F();
        }
    }

    protected void func_73869_a(char c, int id) throws IOException {
        boolean shift = Keyboard.isKeyDown((int)42);
        if (shift && id == 210) {
            this.renderSlotDebugIDs = !this.renderSlotDebugIDs;
            Minecraft.func_71410_x().field_71439_g.func_71165_d("Render Slot IDS: " + this.renderSlotDebugIDs);
        } else if (shift && id == 199) {
            this.renderToolTips = !this.renderToolTips;
            Minecraft.func_71410_x().field_71439_g.func_71165_d("Render Tooltips: " + this.renderToolTips);
        } else if (shift && id == 207) {
            this.renderFluidTanks = !this.renderFluidTanks;
            Minecraft.func_71410_x().field_71439_g.func_71165_d("Render Fluid Tanks: " + this.renderFluidTanks);
        } else if (shift && id == 200) {
            this.renderTextFields = !this.renderTextFields;
            Minecraft.func_71410_x().field_71439_g.func_71165_d("Render Text Fields: " + this.renderTextFields);
        } else if (shift && id == 208) {
            this.renderSlots = !this.renderSlots;
            Minecraft.func_71410_x().field_71439_g.func_71165_d("Render Slots: " + this.renderSlots);
        } else if (shift && id == 203) {
            this.traceSlotDraw = !this.traceSlotDraw;
            Minecraft.func_71410_x().field_71439_g.func_71165_d("Debug Slot Render Calls: " + this.traceSlotDraw + "   !!expect debug spam");
        } else {
            boolean f = false;
            for (GuiTextField field : this.fields) {
                field.func_146201_a(c, id);
                if (!field.func_146206_l()) continue;
                return;
            }
            if (!f) {
                super.func_73869_a(c, id);
            }
        }
    }

    protected void func_73864_a(int p_73864_1_, int p_73864_2_, int p_73864_3_) throws IOException {
        super.func_73864_a(p_73864_1_, p_73864_2_, p_73864_3_);
        for (GuiTextField field : this.fields) {
            field.func_146192_a(p_73864_1_, p_73864_2_, p_73864_3_);
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        this.func_146276_q_();
        this.field_146297_k.field_71446_o.func_110577_a(this.baseTexture);
        this.setColor(null);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void drawContainerSlots() {
        for (Object object : this.field_147002_h.field_75151_b) {
            this.drawSlotBackground((Slot)object);
        }
    }

    protected void drawSlotBackground(Slot slot) {
        if (this.traceSlotDraw) {
            AtomicScience.logger.info("Trace for slot renders", (Throwable)new RuntimeException());
        }
        if (this.renderSlots) {
            if (slot instanceof ISlotRender) {
                GlStateManager.func_179094_E();
                this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
                this.setColor(null);
                ((ISlotRender)slot).renderSlotOverlay((Gui)this, this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1);
                GlStateManager.func_179121_F();
            } else {
                this.drawSlotBackground(slot.field_75223_e - 1, slot.field_75221_f - 1);
            }
            if (this.renderSlotDebugIDs) {
                GlStateManager.func_179094_E();
                this.drawStringCentered("" + slot.getSlotIndex(), this.field_147003_i + slot.field_75223_e + 9, this.field_147009_r + slot.field_75221_f + 9, Color.YELLOW);
                this.drawStringCentered("" + slot.field_75222_d, this.field_147003_i + slot.field_75223_e + 9, this.field_147009_r + slot.field_75221_f + 1, Color.RED);
                this.setColor(null);
                GlStateManager.func_179121_F();
            }
        }
    }

    protected void drawSlotBackground(int x, int y) {
        GlStateManager.func_179094_E();
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        this.setColor(null);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 0, 0, 18, 18);
        GlStateManager.func_179121_F();
    }

    public void drawLargeBar(int x, int y, int w, float percent, Color color) {
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        int width = Math.round(percent * 138.0f);
        this.setColor(null);
        this.drawRectWithScaledWidth(this.field_147003_i + x, this.field_147009_r + y, 54, 33, 140, 15, w);
        this.setColor(color);
        this.drawRectWithScaledWidth(this.field_147003_i + x + 1, this.field_147009_r + y + 1, 55, 65, width, 13, w);
    }

    public void drawSmallBar(int x, int y, int w, float percent, Color color) {
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        int width = Math.round(percent * 105.0f);
        this.setColor(null);
        this.drawRectWithScaledWidth(this.field_147003_i + x, this.field_147009_r + y, 54, 0, 107, 11, w);
        this.setColor(color);
        this.drawRectWithScaledWidth(this.field_147003_i + x + 1, this.field_147009_r + y + 1, 55, 24, width, 9, w);
    }

    public void drawMicroBar(int x, int y, float percent, Color color) {
        this.drawMicroBar(x, y, -1, percent, color);
    }

    public void drawMicroBar(int x, int y, int w, float percent, Color color) {
        int backgroundWidth = 56;
        int fillBarWidth = 54;
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        this.setColor(null);
        this.drawRectWithScaledWidth(this.field_147003_i + x, this.field_147009_r + y, 54, 79, 56, 7, w);
        int width = Math.round(percent * 54.0f);
        this.setColor(color);
        this.drawRectWithScaledWidth(this.field_147003_i + x + 1, this.field_147009_r + y + 1, 55, 87, width, 5, (int)((float)(w - 2) * percent));
    }

    protected void drawRectWithScaledWidth(int x, int y, int u, int v, int width, int height, int newWidth) {
        if (width > 0) {
            if (newWidth <= 0 || width == newWidth) {
                this.func_73729_b(x, y, u, v, width, height);
            }
            int midWidth = width - 6;
            this.func_73729_b(x, y, u, v, 3, height);
            x += 3;
            if (newWidth > 6) {
                int loops;
                for (loops = newWidth / width; loops > 0; --loops) {
                    this.func_73729_b(x, y, u + 3, v, midWidth, height);
                    x += midWidth;
                }
                loops = newWidth % width;
                if (loops != 0) {
                    this.func_73729_b(x, y, u + 3, v, loops, height);
                    x += loops;
                }
            }
            if (width > 3) {
                this.func_73729_b(x, y, u + width - 3, v, 3, height);
            }
        }
    }

    protected void setColor(Color color) {
        if (color == null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GlStateManager.func_179124_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
        }
    }

    protected void drawElectricity(int x, int y, float scale) {
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        this.setColor(null);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 54, 0, 107, 11);
        if (scale > 0.0f) {
            this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 54, 22, (int)(scale * 107.0f), 11);
        }
    }

    protected void drawFluidTank(int x, int y, IFluidTank tank) {
        this.drawFluidTank(x, y, tank, null);
    }

    protected void drawFluidTank(int x, int y, IFluidTank tank, Color edgeColor) {
        if (this.renderFluidTanks) {
            float scale = (float)tank.getFluidAmount() / (float)tank.getCapacity();
            FluidStack fluidStack = tank.getFluid();
            this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (edgeColor != null) {
                this.setColor(edgeColor);
                this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 40, 0, this.meterWidth, this.meterHeight);
                this.setColor(null);
                this.func_73729_b(this.field_147003_i + x + 1, this.field_147009_r + y + 1, 41, 1, this.meterWidth - 2, this.meterHeight - 2);
            } else {
                this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 40, 0, this.meterWidth, this.meterHeight);
            }
            if (fluidStack != null) {
                this.drawFluid(this.field_147003_i + x, this.field_147009_r + y, -10, 1, 12, (int)((float)(this.meterHeight - 1) * scale), fluidStack);
            }
            this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
            this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 40, 98, this.meterWidth, this.meterHeight);
            this.setColor(null);
        }
    }

    public void drawTooltip(int x, int y, String ... tooltips) {
        this.drawTooltip(x, y, Lists.newArrayList((Object[])tooltips));
    }

    public void drawTooltip(int x, int y, List<String> tooltips) {
        this.drawHoveringText(tooltips, x, y, this.field_146289_q);
    }

    protected void drawFluid(int x, int y, int line, int col, int width, int drawSize, FluidStack fluidStack) {
        if (fluidStack != null && fluidStack.getFluid() != null) {
            TextureAtlasSprite texture;
            --drawSize;
            ResourceLocation fluidIcon = null;
            Fluid fluid = fluidStack.getFluid();
            if (fluid != null) {
                fluidIcon = fluid.getStill(fluidStack) != null ? fluid.getStill(fluidStack) : (fluid.getFlowing(fluidStack) != null ? fluid.getFlowing(fluidStack) : FluidRegistry.WATER.getStill());
            }
            if ((texture = FMLClientHandler.instance().getClient().func_147117_R().func_110572_b(fluidIcon.toString())) != null) {
                FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                int textureSize = 16;
                int start = 0;
                if (fluidIcon != null) {
                    int renderY = 16;
                    while (renderY != 0 && drawSize != 0) {
                        if (drawSize > 16) {
                            renderY = 16;
                            drawSize -= 16;
                        } else {
                            renderY = drawSize;
                            drawSize = 0;
                        }
                        this.func_175175_a(x + col, y + line + 58 - renderY - start, texture, width, 16 - (16 - renderY));
                        start += 16;
                    }
                }
            }
        }
    }

    protected void renderFurnaceCookArrow(int x, int y, int cookTime, int maxCookTime) {
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        this.setColor(null);
        cookTime = Math.min(cookTime, maxCookTime);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 18, 0, 22, 15);
        if (cookTime > 0) {
            float p = (float)cookTime / ((float)maxCookTime + 0.0f);
            this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 18, 15, (int)Math.floor(22.0f * p), 15);
        }
    }
}

