/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.fluid;

import com.builtbroken.atomic.lib.SideSettings;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidSideWrapper
implements IFluidHandler {
    protected final HashMap<SideSettings, IFluidTank> sideToTank = new HashMap();
    protected final HashMap<SideSettings, Boolean> sideToType = new HashMap();
    public final EnumFacing side;

    public FluidSideWrapper(EnumFacing side) {
        this.side = side;
    }

    public void add(SideSettings sideSettings, IFluidTank tank, boolean output) {
        this.sideToTank.put(sideSettings, tank);
        this.sideToType.put(sideSettings, output);
    }

    public IFluidTankProperties[] getTankProperties() {
        return FluidTankProperties.convert((FluidTankInfo[])((FluidTankInfo[])this.sideToTank.entrySet().stream().filter(entry -> ((SideSettings)entry.getKey()).get(this.side)).map(entry -> ((IFluidTank)entry.getValue()).getInfo()).toArray(FluidTankInfo[]::new)));
    }

    public int fill(FluidStack resource, boolean doFill) {
        int fill = 0;
        for (Map.Entry<SideSettings, IFluidTank> entry : this.sideToTank.entrySet()) {
            if (this.sideToType.get(entry.getKey()).booleanValue() || !entry.getKey().get(this.side) || resource == null || resource.amount <= 0) continue;
            fill += entry.getValue().fill(resource, doFill);
        }
        return fill;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        for (Map.Entry<SideSettings, IFluidTank> entry : this.sideToTank.entrySet()) {
            if (!this.sideToType.get(entry.getKey()).booleanValue() || !entry.getKey().get(this.side) || entry.getValue().getFluid() == null || !entry.getValue().getFluid().isFluidEqual(resource)) continue;
            return entry.getValue().drain(resource.amount, doDrain);
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        for (Map.Entry<SideSettings, IFluidTank> entry : this.sideToTank.entrySet()) {
            if (!this.sideToType.get(entry.getKey()).booleanValue() || !entry.getKey().get(this.side) || entry.getValue().getFluid() == null) continue;
            return entry.getValue().drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean hasTank() {
        return this.sideToTank.entrySet().stream().anyMatch(entry -> ((SideSettings)entry.getKey()).get(this.side));
    }
}

