/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib;

import com.builtbroken.atomic.AtomicScience;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class LanguageUtility {
    public static int toolTipLineLength = 120;

    public static String getLocal(String key) {
        if (key == null || key.isEmpty()) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error("LanguageUtility.getLocalName(" + key + ") - invalid key", (Throwable)new RuntimeException());
            }
            return I18n.func_135052_a((String)"error.translation.null", (Object[])new Object[]{key});
        }
        if (I18n.func_188566_a((String)key)) {
            String translation = I18n.func_135052_a((String)key, (Object[])new Object[0]);
            if (translation == null || translation.isEmpty()) {
                return I18n.func_135052_a((String)"error.translation.empty", (Object[])new Object[]{key});
            }
            return translation;
        }
        return I18n.func_135052_a((String)"error.translation.empty", (Object[])new Object[]{key});
    }

    public static void getLocal(String key, List<String> tooltip) {
        if (I18n.func_188566_a((String)key)) {
            String translation = LanguageUtility.getLocal(key);
            if (translation.contains(",")) {
                String[] split;
                for (String s : split = translation.split(",")) {
                    tooltip.add(s.trim());
                }
            } else {
                tooltip.add(translation);
            }
        }
    }

    public static String getLocalName(String key) {
        return LanguageUtility.getLocal(key + ".name");
    }

    public static Integer getLangSetting(String key, int backup) {
        block3: {
            String result = LanguageUtility.getLocal(key);
            if (result != null && !result.isEmpty()) {
                try {
                    return Integer.parseInt(key);
                }
                catch (NumberFormatException e) {
                    if (!AtomicScience.runningAsDev) break block3;
                    AtomicScience.logger.error("LanguageUtility.getLangSetting(" + key + ")", (Throwable)e);
                }
            }
        }
        return backup;
    }

    public static ITextComponent getLocalChat(String key) {
        String translation = LanguageUtility.getLocalName(key);
        if (translation == null || translation.isEmpty()) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error("LanguageUtility.getLocalChat(" + key + ")", (Throwable)new RuntimeException());
            }
            return new TextComponentTranslation("error.translation.empty", new Object[]{key});
        }
        return new TextComponentTranslation(translation, new Object[0]);
    }

    public static void addChatToPlayer(EntityPlayer player, String key) {
        if (player != null) {
            player.func_145747_a(LanguageUtility.getLocalChat(key));
        } else if (AtomicScience.runningAsDev) {
            AtomicScience.logger.error("LanguageUtility.addChatToPlayer(Null Player, " + key + ")", (Throwable)new RuntimeException());
        }
    }

    public static List<String> splitStringPerWord(String string) {
        return Arrays.asList(LanguageUtility.toWordArray(string));
    }

    public static String[] toWordArray(String string) {
        return string.trim().split("\\W+");
    }

    public static List<String> splitByLine(String string, int charsPerLine) {
        if (string.length() < charsPerLine) {
            return Lists.newArrayList((Object[])new String[]{string});
        }
        String[] words = LanguageUtility.toWordArray(string);
        ArrayList<String> lines = new ArrayList<String>();
        String line = "";
        for (String word : words) {
            if (word.length() + line.length() <= charsPerLine) {
                line = line + word;
                continue;
            }
            lines.add(line);
            line = word;
        }
        if (lines.isEmpty()) {
            lines.add(line);
        }
        return lines;
    }

    public static String capitalizeFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
    }

    public static String decapitalizeFirst(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1, str.length());
    }
}

