/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.recipes.loot;

import com.builtbroken.atomic.content.recipes.loot.RecipeRandomItem;
import com.builtbroken.atomic.proxy.ContentProxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeLootTable
extends ContentProxy {
    protected final List<RecipeRandomItem> lootItems = new ArrayList<RecipeRandomItem>();
    protected final Random random = new Random();
    protected int totalWeight = 0;

    public RecipeLootTable(String name) {
        super(name);
    }

    public void calculateTotalWeight() {
        this.totalWeight = 0;
        this.lootItems.forEach(e -> this.totalWeight += e.weight);
    }

    public void loadConfiguration() {
        this.calculateTotalWeight();
    }

    protected void addEntries(String ore_name, int weight, Function<ItemStack, Boolean> function) {
        if (OreDictionary.doesOreNameExist((String)ore_name)) {
            for (ItemStack stack : OreDictionary.getOres((String)ore_name)) {
                if (stack == null || stack.func_77973_b() == null || !function.apply(stack).booleanValue()) continue;
                this.addEntry(ore_name, stack, weight);
            }
        }
    }

    protected void addEntry(String ore_name, ItemStack stack, int weight) {
        ItemStack stack1 = stack.func_77946_l();
        stack1.func_190920_e(1);
        RecipeRandomItem recipeRandomItem = new RecipeRandomItem(weight, stack1);
        this.lootItems.add(recipeRandomItem);
    }

    protected boolean hasIngot(ItemStack itemStack) {
        ItemStack smeltingResult;
        if (itemStack != null && itemStack.func_77973_b() != null && !(smeltingResult = FurnaceRecipes.func_77602_a().func_151395_a(itemStack)).func_190926_b() && smeltingResult.func_77973_b() != null) {
            for (int id : OreDictionary.getOreIDs((ItemStack)smeltingResult)) {
                String name = OreDictionary.getOreName((int)id);
                if (name == null || !name.toLowerCase().contains("ingot")) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack getRandomItemStack() {
        ItemStack stack;
        if (this.totalWeight <= 0) {
            this.calculateTotalWeight();
        }
        int randomWeight = this.random.nextInt(1 + this.totalWeight);
        Iterator<RecipeRandomItem> iterator = this.lootItems.iterator();
        RecipeRandomItem itemEntry = null;
        do {
            if (!iterator.hasNext()) {
                return ItemStack.field_190927_a;
            }
            RecipeRandomItem next = iterator.next();
            if (next.weight <= 0) continue;
            randomWeight -= next.weight;
            itemEntry = next;
        } while (randomWeight >= 0);
        if (itemEntry != null && (stack = itemEntry.getRandomStack()) != null && !stack.func_190926_b()) {
            if (stack.func_190916_E() <= 0) {
                stack.func_190920_e(1);
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

