/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.recipes.chem;

import com.builtbroken.atomic.content.machines.TileEntityInventoryMachine;
import com.builtbroken.atomic.content.machines.processing.TileEntityProcessingMachine;
import com.builtbroken.atomic.content.recipes.RecipeProcessing;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public abstract class RecipeChemMachine<H extends TileEntityProcessingMachine>
extends RecipeProcessing<H> {
    private final Object _input;
    private final ItemStack _output;

    public RecipeChemMachine(Object input, ItemStack output) {
        this._input = input;
        this._output = output;
    }

    protected abstract int getInputSlot();

    protected abstract int getOutputSlot();

    @Nullable
    public Object getInput(@Nullable H machine) {
        return this._input;
    }

    @Nullable
    public ItemStack getOutput(@Nullable H machine) {
        return this._output;
    }

    @Nullable
    public List<ItemStack> getPossibleInputs() {
        Object input = this.getInput(null);
        if (input instanceof ItemStack) {
            if (!((ItemStack)input).func_190926_b()) {
                return Lists.newArrayList((Object[])new ItemStack[]{(ItemStack)input});
            }
        } else if (input instanceof String) {
            return OreDictionary.getOres((String)((String)input));
        }
        return null;
    }

    @Nullable
    public List<ItemStack> getPossibleOutputs() {
        ItemStack output = this.getOutput(null);
        if (output != null && !output.func_190926_b()) {
            return Lists.newArrayList((Object[])new ItemStack[]{output});
        }
        return null;
    }

    @Override
    public boolean matches(H machine) {
        return this.hasInput(machine) && this.canOutput(machine);
    }

    protected boolean hasInput(H machine) {
        if (this.getInputSlot() < 0) {
            return true;
        }
        Object input = this.getInput(machine);
        if (input == null || input instanceof ItemStack && ((ItemStack)input).func_190926_b()) {
            return true;
        }
        return RecipeChemMachine.matches(input, ((TileEntityInventoryMachine)machine).getInventory().getStackInSlot(this.getInputSlot()));
    }

    protected boolean canOutput(H machine) {
        return this.getOutputSlot() < 0 || this.getOutput(machine).func_190926_b() || ((TileEntityInventoryMachine)machine).getInventory().insertItem(this.getOutputSlot(), this.getOutput(machine), true).func_190926_b();
    }

    @Override
    public boolean applyRecipe(H machine) {
        if (this.matches(machine)) {
            this.doRecipe(machine, ((TileEntityInventoryMachine)machine).getInventory());
        }
        return false;
    }

    protected void doRecipe(H machine, IItemHandlerModifiable inventory) {
        ItemStack outputStack;
        if (this.getInput(machine) != null) {
            inventory.extractItem(this.getInputSlot(), 1, false);
        }
        if ((outputStack = this.getOutput(machine)) != null && !outputStack.func_190926_b()) {
            inventory.insertItem(this.getOutputSlot(), this.getOutput(machine).func_77946_l(), false);
        }
    }

    @Override
    public boolean isComponent(H machine, ItemStack stack) {
        if (this.getInput(machine) != null) {
            return RecipeChemMachine.matches(this.getInput(machine), stack);
        }
        return false;
    }
}

