/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.recipes.chem;

import com.builtbroken.atomic.content.machines.processing.centrifuge.TileEntityChemCentrifuge;
import com.builtbroken.atomic.content.recipes.chem.RecipeChemMachine;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;

public class RecipeChemCentrifuge
extends RecipeChemMachine<TileEntityChemCentrifuge> {
    public final FluidStack inputTank;
    public final FluidStack outputTank;

    public RecipeChemCentrifuge(ItemStack output, FluidStack inputTank, FluidStack outputTank) {
        super(null, output);
        this.inputTank = inputTank;
        this.outputTank = outputTank;
    }

    @Override
    protected int getInputSlot() {
        return -1;
    }

    @Override
    protected int getOutputSlot() {
        return 1;
    }

    @Override
    public boolean matches(TileEntityChemCentrifuge machine) {
        return super.matches(machine) && this.hasInputFluid(machine) && this.canOutputFluid(machine);
    }

    protected boolean hasInputFluid(TileEntityChemCentrifuge machine) {
        if (this.inputTank != null) {
            return machine.hasInputFluid((IFluidTank)machine.getInputTank(), this.inputTank.getFluid(), this.inputTank.amount);
        }
        return true;
    }

    protected boolean canOutputFluid(TileEntityChemCentrifuge machine) {
        if (this.outputTank != null) {
            return machine.canOutputFluid((IFluidTank)machine.getOutputTank(), this.outputTank.getFluid(), this.outputTank.amount);
        }
        return true;
    }

    @Override
    protected void doRecipe(TileEntityChemCentrifuge machine, IItemHandlerModifiable inventory) {
        super.doRecipe(machine, inventory);
        if (this.inputTank != null) {
            machine.getInputTank().drain(this.inputTank, true);
        }
        if (this.outputTank != null) {
            machine.getOutputTank().fill(this.outputTank, true);
        }
    }

    @Override
    public boolean isComponent(TileEntityChemCentrifuge machine, Fluid fluid) {
        if (this.inputTank != null) {
            return this.inputTank.getFluid() == fluid;
        }
        return false;
    }
}

