/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.recipes.chem;

import com.builtbroken.atomic.content.machines.processing.boiler.TileEntityChemBoiler;
import com.builtbroken.atomic.content.recipes.chem.RecipeChemMachine;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;

public class RecipeChemBoiler
extends RecipeChemMachine<TileEntityChemBoiler> {
    public final FluidStack inputTankBlue;
    public final FluidStack outputTankGreen;
    public final FluidStack outputTankYellow;

    public RecipeChemBoiler(Object input, ItemStack output, FluidStack inputTankBlue, FluidStack outputTankGreen, FluidStack outputTankYellow) {
        super(input, output);
        this.inputTankBlue = inputTankBlue;
        this.outputTankGreen = outputTankGreen;
        this.outputTankYellow = outputTankYellow;
    }

    @Override
    protected int getInputSlot() {
        return 1;
    }

    @Override
    protected int getOutputSlot() {
        return 2;
    }

    @Override
    public boolean matches(TileEntityChemBoiler machine) {
        return super.matches(machine) && this.hasInputFluid(machine) && this.canOutputGreen(machine) && this.canOutputYellow(machine);
    }

    private boolean hasInputFluid(TileEntityChemBoiler machine) {
        if (this.inputTankBlue != null) {
            return machine.hasInputFluid((IFluidTank)machine.getBlueTank(), this.inputTankBlue.getFluid(), this.inputTankBlue.amount);
        }
        return true;
    }

    private boolean canOutputGreen(TileEntityChemBoiler machine) {
        if (this.outputTankGreen != null) {
            return machine.canOutputFluid((IFluidTank)machine.getGreenTank(), this.outputTankGreen.getFluid(), this.outputTankGreen.amount);
        }
        return true;
    }

    private boolean canOutputYellow(TileEntityChemBoiler machine) {
        if (this.outputTankYellow != null) {
            return machine.canOutputFluid((IFluidTank)machine.getYellowTank(), this.outputTankYellow.getFluid(), this.outputTankYellow.amount);
        }
        return true;
    }

    @Override
    protected void doRecipe(TileEntityChemBoiler machine, IItemHandlerModifiable inventory) {
        super.doRecipe(machine, inventory);
        if (this.inputTankBlue != null) {
            machine.getBlueTank().drain(this.inputTankBlue, true);
        }
        if (this.outputTankGreen != null) {
            machine.getGreenTank().fill(this.outputTankGreen, true);
        }
        if (this.outputTankYellow != null) {
            machine.getYellowTank().fill(this.outputTankYellow, true);
        }
    }

    @Override
    public boolean isComponent(TileEntityChemBoiler machine, Fluid fluid) {
        if (this.inputTankBlue != null) {
            return this.inputTankBlue.getFluid() == fluid;
        }
        return false;
    }
}

