/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.prefab;

import com.builtbroken.atomic.content.prefab.BlockMachine;
import com.builtbroken.atomic.lib.gui.IPlayerUsing;
import com.builtbroken.atomic.lib.transform.IPosWorld;
import com.builtbroken.atomic.network.IPacket;
import com.builtbroken.atomic.network.IPacketIDReceiver;
import com.builtbroken.atomic.network.netty.PacketSystem;
import com.builtbroken.atomic.network.packet.PacketTile;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TileEntityPrefab
extends TileEntity
implements IPacketIDReceiver,
IPosWorld,
IPlayerUsing {
    public static final int DESC_PACKET_ID = -1;
    public static final int GUI_PACKET_ID = -2;
    private final ArrayList<EntityPlayer> playersUsingGUI = new ArrayList();

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, IPacket type) {
        if (this.isClient()) {
            if (id == -1) {
                this.readDescPacket(buf, player);
                return true;
            }
            if (id == -2) {
                this.readGuiPacket(buf, player);
                return true;
            }
        }
        return false;
    }

    protected void sendDescPacket() {
        if (this.isServer()) {
            PacketTile packetTile = new PacketTile("reactor_desc", -1, this);
            ArrayList<Object> list = new ArrayList<Object>();
            this.writeDescPacket(list, null);
            packetTile.addData(list);
            PacketSystem.INSTANCE.sendToAllAround((IPacket)packetTile, this);
        }
    }

    protected void sendGuiPacket() {
        Iterator<EntityPlayer> it = this.getPlayersUsingGui().iterator();
        while (it.hasNext()) {
            EntityPlayer player = it.next();
            if (this.sendGuiPacket(player)) continue;
            it.remove();
        }
    }

    public boolean sendGuiPacket(EntityPlayer player) {
        if (player instanceof EntityPlayerMP && this.shouldSendGuiPacket((EntityPlayerMP)player)) {
            PacketTile packet = new PacketTile("gui", -2, this);
            ArrayList<Object> objects = new ArrayList<Object>();
            this.writeGuiPacket(objects, player);
            packet.addData(objects);
            PacketSystem.INSTANCE.sendToPlayer(packet, (EntityPlayer)((EntityPlayerMP)player));
            return true;
        }
        return false;
    }

    protected void writeDescPacket(List<Object> dataList, EntityPlayer player) {
    }

    protected void readDescPacket(ByteBuf buf, EntityPlayer player) {
    }

    protected void writeGuiPacket(List<Object> dataList, EntityPlayer player) {
    }

    protected void readGuiPacket(ByteBuf buf, EntityPlayer player) {
    }

    public final boolean isServer() {
        return this.func_145831_w() != null && !this.func_145831_w().field_72995_K;
    }

    public final boolean isClient() {
        return this.func_145831_w() != null && this.func_145831_w().field_72995_K;
    }

    @Override
    public Collection<EntityPlayer> getPlayersUsingGui() {
        return this.playersUsingGUI;
    }

    protected boolean shouldSendGuiPacket(EntityPlayerMP playerMP) {
        return playerMP.func_70089_S() && playerMP.field_71070_bA != null;
    }

    @Override
    public World world() {
        return this.func_145831_w();
    }

    @Override
    public int dim() {
        if (this.func_145831_w() == null) {
            return 0;
        }
        if (this.func_145831_w().field_73011_w == null) {
            return 0;
        }
        return this.func_145831_w().field_73011_w.getDimension();
    }

    public String worldName() {
        if (this.func_145831_w() == null) {
            return "-null-";
        }
        if (this.func_145831_w().func_72912_H() == null) {
            return "-null info-";
        }
        return this.func_145831_w().func_72912_H().func_76065_j();
    }

    @Override
    public double z() {
        return (double)this.zi() + 0.5;
    }

    @Override
    public double x() {
        return (double)this.xi() + 0.5;
    }

    @Override
    public double y() {
        return (double)this.yi() + 0.5;
    }

    @Override
    public int zi() {
        return this.field_174879_c.func_177952_p();
    }

    @Override
    public int xi() {
        return this.field_174879_c.func_177958_n();
    }

    @Override
    public int yi() {
        return this.field_174879_c.func_177956_o();
    }

    public TileEntity getTileEntity(BlockPos pos) {
        return this.field_145850_b != null ? this.field_145850_b.func_175625_s(pos) : null;
    }

    public TileEntity getTileEntityIfLoaded(BlockPos pos) {
        return this.field_145850_b != null && this.field_145850_b.func_175667_e(pos) ? this.getTileEntity(pos) : null;
    }

    public TileEntity getTileEntity(BlockPos pos, EnumFacing side) {
        return this.getTileEntity(pos.func_177972_a(side));
    }

    public TileEntity getTileEntity(EnumFacing side) {
        return this.getTileEntity(this.func_174877_v().func_177972_a(side));
    }

    public <T> T getCapabilityOnSide(Capability<T> cap, EnumFacing side) {
        TileEntity tileEntity = this.getTileEntity(side);
        if (tileEntity != null && tileEntity.hasCapability(cap, side.func_176734_d())) {
            return (T)tileEntity.getCapability(cap, side.func_176734_d());
        }
        return null;
    }

    public IBlockState getState(BlockPos pos) {
        return this.field_145850_b != null ? this.field_145850_b.func_180495_p(pos) : null;
    }

    public IBlockState getState() {
        return this.getState(this.func_174877_v());
    }

    public IBlockState getState(BlockPos pos, EnumFacing side) {
        return this.getState(pos.func_177972_a(side));
    }

    public IBlockState getState(EnumFacing side) {
        return this.getState(this.func_174877_v(), side);
    }

    public EnumFacing getDirection() {
        EnumFacing facing;
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177227_a().contains(BlockMachine.ROTATION_PROP) && (facing = (EnumFacing)state.func_177229_b((IProperty)BlockMachine.ROTATION_PROP)) != null) {
            return facing;
        }
        return EnumFacing.UP;
    }

    public void setDirection(EnumFacing facing) {
        IBlockState state;
        if (this.getDirection() != facing && (state = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177227_a().contains(BlockMachine.ROTATION_PROP)) {
            state = state.func_177226_a((IProperty)BlockMachine.ROTATION_PROP, (Comparable)facing);
            this.field_145850_b.func_175656_a(this.func_174877_v(), state);
        }
    }

    public void onDirectionChanged(EnumFacing direction) {
    }
}

