/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.steam.generator;

import com.builtbroken.atomic.config.logic.ConfigLogic;
import com.builtbroken.atomic.config.mods.ConfigMod;
import com.builtbroken.atomic.content.machines.steam.TileEntitySteamInput;
import com.builtbroken.atomic.content.machines.steam.generator.FakeEnergyStorage;
import com.builtbroken.atomic.lib.power.PowerSystem;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")})
public class TileEntitySteamGenerator
extends TileEntitySteamInput
implements IEnergySource {
    public float _clientTurbineRotation = 0.0f;
    public float _clientPrevRotation = 0.0f;
    private IEnergyStorage energyStorage = new FakeEnergyStorage();
    private boolean hasValidated = false;

    @Override
    protected void update(int ticks, boolean isClient) {
        super.update(ticks, isClient);
        if (isClient) {
            this._clientTurbineRotation += this.getRotationSpeed();
            if (this._clientTurbineRotation > 360.0f) {
                this._clientTurbineRotation -= 360.0f;
                this._clientPrevRotation -= 360.0f;
            }
        }
        PowerSystem.outputPower(this, EnumFacing.UP, this.getPowerToOutput(), true);
    }

    @Nullable
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        return (T)super.getCapability(capability, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public float rotate(float delta) {
        this._clientPrevRotation += (this._clientTurbineRotation - this._clientPrevRotation) * delta;
        return this._clientPrevRotation;
    }

    public float getRotationSpeed() {
        return (float)this.getSteamGeneration() / 1000.0f * 10.0f;
    }

    public int getPowerToOutput() {
        return this.getSteamGeneration() * ConfigLogic.STEAM.STEAM_TO_ENERGY;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        return super.func_189515_b(nbt);
    }

    protected boolean enableIC2Support() {
        return ConfigMod.IC2.ENABLE_POWER;
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        if (this.enableIC2Support()) {
            return (double)this.getPowerToOutput() / ConfigMod.IC2.FE_PER_EU;
        }
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return 1;
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return this.enableIC2Support() && this.hasCapability(CapabilityEnergy.ENERGY, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hasValidated) {
            this.hasValidated = false;
            PowerSystem.forEach(proxy -> proxy.onTileInvalidate(this));
        }
    }

    public void func_145829_t() {
        boolean wasInvalid = this.field_145846_f;
        super.func_145829_t();
        if (!this.hasValidated && !wasInvalid) {
            this.hasValidated = true;
            PowerSystem.forEach(proxy -> proxy.onTileValidate(this));
        }
    }
}

