/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.steam.funnel;

import com.builtbroken.atomic.content.ASFluids;
import com.builtbroken.atomic.content.machines.steam.SteamTank;
import com.builtbroken.atomic.content.machines.steam.TileEntitySteamInput;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntitySteamFunnel
extends TileEntitySteamInput {
    private FluidTank tank = new SteamTank(this, 10000);

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    protected void update(int ticks, boolean isClient) {
        super.update(ticks, isClient);
        if (!isClient) {
            if (this.tank.getFluid() != null && this.tank.getFluid().getFluid() != ASFluids.STEAM.fluid) {
                this.tank.drain(this.tank.getCapacity(), true);
            }
            if (this.tank.getFluid() != null && this.tank.getFluidAmount() > 0) {
                int amountToGive = this.tank.getFluidAmount();
                for (EnumFacing direction : EnumFacing.field_82609_l) {
                    IFluidHandler fluidHandler;
                    BlockPos blockPos = this.func_174877_v().func_177971_a(direction.func_176730_m());
                    TileEntity tile = this.field_145850_b.func_175625_s(blockPos);
                    if (tile == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction) || (fluidHandler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction)) == null) continue;
                    int give = amountToGive / 6;
                    give = fluidHandler.fill(new FluidStack(this.tank.getFluid().getFluid(), give), true);
                    amountToGive -= give;
                }
                this.tank.drain(this.tank.getFluidAmount() - amountToGive, true);
            }
            if (this.getSteamGeneration() > 0) {
                this.tank.fill(new FluidStack(ASFluids.STEAM.fluid, this.getSteamGeneration()), true);
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.writeToNBT(nbt.func_74775_l("fluid_tank"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("fluid_tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return super.func_189515_b(nbt);
    }
}

