/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.sensors.thermal.gui;

import com.builtbroken.atomic.content.items.ItemHeatProbe;
import com.builtbroken.atomic.content.machines.sensors.thermal.TileEntityThermalRedstone;
import com.builtbroken.atomic.content.machines.sensors.thermal.gui.ContainerThermalRedstone;
import com.builtbroken.atomic.lib.LanguageUtility;
import com.builtbroken.atomic.lib.gui.GuiContainerBase;
import com.builtbroken.atomic.lib.timer.TickTimerConditional;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;

public class GuiThermalRedstone
extends GuiContainerBase<TileEntityThermalRedstone> {
    private GuiTextField minTriggerField;
    private GuiTextField maxTriggerField;
    private String infoMessage;
    private TickTimerConditional fieldRefreshTimer = TickTimerConditional.newSimple(40, ticks -> this.refreshFields()).setShouldTickFunction(() -> !this.areFieldsSelected()).setShouldResetFunction(() -> this.areFieldsSelected());

    public GuiThermalRedstone(EntityPlayer player, TileEntityThermalRedstone host) {
        super(new ContainerThermalRedstone(player, host), host);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.minTriggerField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 72, this.field_147009_r + 28, 80, 12);
        this.fields.add(this.minTriggerField);
        this.maxTriggerField = new GuiTextField(1, this.field_146289_q, this.field_147003_i + 72, this.field_147009_r + 48, 80, 12);
        this.fields.add(this.maxTriggerField);
        this.refreshFields();
        this.field_146292_n.add(new GuiButton(2, this.field_147003_i + 130, this.field_147009_r + 64, 35, 20, this.getLocal("button.set")));
        this.field_146292_n.add(new GuiButton(3, this.field_147003_i + 110, this.field_147009_r + 125, 55, 20, this.getLocal("button.get")));
    }

    private String formatHeat(int number) {
        String string = ItemHeatProbe.formatTemp(number);
        string = string.substring(0, string.length() - 1).trim();
        string = string.replaceAll("\\s", "");
        return string;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.fieldRefreshTimer.tick();
    }

    protected boolean areFieldsSelected() {
        return this.minTriggerField.func_146206_l() || this.maxTriggerField.func_146206_l();
    }

    protected void refreshFields() {
        this.minTriggerField.func_146180_a("" + this.formatHeat(((TileEntityThermalRedstone)this.host).minHeatTrigger * 1000));
        this.maxTriggerField.func_146180_a("" + this.formatHeat(((TileEntityThermalRedstone)this.host).maxHeatTrigger * 1000));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 2) {
            try {
                this.infoMessage = null;
                int min = this.parseInt(this.minTriggerField.func_146179_b());
                int max = this.parseInt(this.maxTriggerField.func_146179_b());
                if (min == -1 || max == -1) {
                    return;
                }
                if (min < 1000) {
                    this.infoMessage = "e:numbers under 1000 can't be used";
                    return;
                }
                if (max < min) {
                    this.infoMessage = "e:max needs to be larger than min";
                    return;
                }
                ((TileEntityThermalRedstone)this.host).setTriggerClient(min / 1000, max / 1000);
                this.infoMessage = "data set";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (button.field_146127_k == 3) {
            ((TileEntityThermalRedstone)this.host).requestHeatValue();
        }
    }

    public int parseInt(String string) {
        if (string == null) {
            return 0;
        }
        if ((string = string.toLowerCase().trim()).isEmpty()) {
            return 0;
        }
        try {
            if (string.matches("[0-9]+")) {
                return Integer.parseInt(string);
            }
            if (!string.matches("^(?=.*[a-z])(?=.*[0-9.])[a-z0-9.]+$")) {
                this.infoMessage = "e:When using a suffix you need 1 letter and number minimal";
                return -1;
            }
            String[] split = string.split("(?<=[a-z])(?=[0-9.])|(?<=[0-9.])(?=[a-z])");
            String num = split[0];
            String suffix = split[1];
            double number = Double.parseDouble(num);
            if (suffix.equals("k")) {
                return (int)Math.floor(number * 1000.0);
            }
            if (suffix.equals("m")) {
                return (int)Math.floor(number * 1000.0 * 1000.0);
            }
            if (suffix.equals("g")) {
                return (int)Math.floor(number * 1000.0 * 1000.0 * 1000.0);
            }
            if (suffix.endsWith("j")) {
                this.infoMessage = "e:No need to include J (joules) in fields";
                return -1;
            }
            this.infoMessage = "e:Unknown suffix: " + suffix;
            return -1;
        }
        catch (NumberFormatException e) {
            this.infoMessage = "e:Not a number";
        }
        catch (Exception e) {
            e.printStackTrace();
            this.infoMessage = "e:Not a number";
        }
        return -1;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.drawStringCentered(this.getLocal("label.title"), this.field_146999_f / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.getLocal("label.min"), 12, 30, 0x404040);
        this.field_146289_q.func_78276_b(this.getLocal("label.max"), 12, 50, 0x404040);
        if (((TileEntityThermalRedstone)this.host).clientHeatValue >= 0) {
            this.field_146289_q.func_78276_b(this.getLocal("label.heat.value") + " " + ItemHeatProbe.formatTemp((long)((TileEntityThermalRedstone)this.host).clientHeatValue * 1000L), 12, 80, 0x404040);
            float scale = ((TileEntityThermalRedstone)this.host).getHeatScale(((TileEntityThermalRedstone)this.host).clientHeatValue);
            int display = (int)Math.floor(scale * 100.0f);
            this.field_146289_q.func_78276_b(display + "%", 120, 92, 0x404040);
            int redstone = ((TileEntityThermalRedstone)this.host).getExpectedRedstoneValue(((TileEntityThermalRedstone)this.host).clientHeatValue);
            this.field_146289_q.func_78276_b(this.getLocal("label.redstone") + " " + redstone, 12, 105, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(this.getLocal("label.heat.none"), 12, 80, 0x404040);
        }
        if (this.infoMessage != null && !this.infoMessage.isEmpty()) {
            if (this.infoMessage.startsWith("e:")) {
                this.field_146289_q.func_78276_b(this.getLocal("label.error") + " " + this.infoMessage.substring(2), 12, 150, 0x404040);
            } else {
                this.field_146289_q.func_78276_b(this.getLocal("label.info") + " " + this.infoMessage, 12, 150, 0x404040);
            }
        }
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        this.field_146297_k.field_71446_o.func_110577_a(GUI_COMPONENTS);
        this.setColor(null);
        int x = 10;
        int y = 90;
        float scale = ((TileEntityThermalRedstone)this.host).getHeatScale(((TileEntityThermalRedstone)this.host).clientHeatValue);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 54, 0, 107, 11);
        if (scale > 0.0f) {
            this.setColor(Color.RED);
            this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 54, 22, (int)(scale * 107.0f), 11);
            this.setColor(null);
        }
    }

    private String getLocal(String suffix) {
        return LanguageUtility.getLocal("gui.atomicscience:sensor.thermal.redstone." + suffix);
    }
}

