/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.sensors.thermal;

import com.builtbroken.atomic.content.machines.sensors.thermal.BlockThermalRedstone;
import com.builtbroken.atomic.content.machines.sensors.thermal.gui.ContainerThermalRedstone;
import com.builtbroken.atomic.content.machines.sensors.thermal.gui.GuiThermalRedstone;
import com.builtbroken.atomic.content.prefab.TileEntityPrefab;
import com.builtbroken.atomic.lib.MetaEnum;
import com.builtbroken.atomic.lib.gui.IGuiTile;
import com.builtbroken.atomic.map.MapHandler;
import com.builtbroken.atomic.network.IPacket;
import com.builtbroken.atomic.network.netty.PacketSystem;
import com.builtbroken.atomic.network.packet.PacketTile;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityThermalRedstone
extends TileEntityPrefab
implements IGuiTile {
    public static final String NBT_MIN_HEAT = "minHeat";
    public static final String NBT_MAX_HEAT = "maxHeat";
    public static final int TRIGGER_SET_PACKET_ID = 1;
    public static final int GET_HEAT_PACKET_ID = 2;
    public int minHeatTrigger = 1000;
    public int maxHeatTrigger = 1000;
    public int clientHeatValue = -1;

    public void onLoad() {
        this.updateRedstoneState(this.field_145850_b.func_180495_p(this.func_174877_v()), MapHandler.THERMAL_MAP.getStoredHeat(this.field_145850_b, this.func_174877_v()));
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, IPacket type) {
        if (!super.read(buf, id, player, type)) {
            if (this.isServer()) {
                if (id == 1) {
                    this.minHeatTrigger = buf.readInt();
                    this.maxHeatTrigger = buf.readInt();
                    int heat = MapHandler.THERMAL_MAP.getStoredHeat(this.field_145850_b, this.func_174877_v());
                    this.updateRedstoneState(this.field_145850_b.func_180495_p(this.func_174877_v()), heat);
                    this.sendGuiPacket();
                    this.func_70296_d();
                    return true;
                }
                if (id == 2) {
                    int heat = MapHandler.THERMAL_MAP.getStoredHeat(this.field_145850_b, this.func_174877_v());
                    PacketSystem.INSTANCE.sendToPlayer((IPacket)new PacketTile("heat_send", 2, this).addData(heat), player);
                    return true;
                }
            } else if (this.isClient() && id == 2) {
                this.clientHeatValue = buf.readInt();
                return true;
            }
            return false;
        }
        return true;
    }

    public void requestHeatValue() {
        PacketSystem.INSTANCE.sendToServer(new PacketTile("heat_get", 2, this));
    }

    public void setTriggerClient(int min, int max) {
        this.minHeatTrigger = min;
        this.maxHeatTrigger = max;
        PacketSystem.INSTANCE.sendToServer((IPacket)new PacketTile("trigger_set", 1, this).addData(min, max));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.minHeatTrigger = compound.func_74762_e(NBT_MIN_HEAT);
        this.maxHeatTrigger = compound.func_74762_e(NBT_MAX_HEAT);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a(NBT_MIN_HEAT, this.minHeatTrigger);
        compound.func_74768_a(NBT_MAX_HEAT, this.maxHeatTrigger);
        return super.func_189515_b(compound);
    }

    @Override
    protected void writeGuiPacket(List<Object> dataList, EntityPlayer player) {
        dataList.add(this.minHeatTrigger);
        dataList.add(this.maxHeatTrigger);
    }

    @Override
    protected void readGuiPacket(ByteBuf buf, EntityPlayer player) {
        this.minHeatTrigger = buf.readInt();
        this.maxHeatTrigger = buf.readInt();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public int getExpectedRedstoneValue(int heatValue) {
        if (heatValue > this.minHeatTrigger) {
            return (int)Math.min(15.0, Math.max(0.0, Math.floor(this.getHeatScale(heatValue) * 15.0f)));
        }
        return 0;
    }

    public float getHeatScale(int heatValue) {
        if (heatValue > this.minHeatTrigger) {
            return Math.max(0.0f, Math.min(1.0f, (float)(heatValue - this.minHeatTrigger) / (float)(this.maxHeatTrigger - this.minHeatTrigger)));
        }
        return 0.0f;
    }

    public void updateRedstoneState(IBlockState blockState, int heatValue) {
        int currentRedstone;
        int redstone = this.getExpectedRedstoneValue(heatValue);
        if (redstone != (currentRedstone = BlockThermalRedstone.getRedstoneValue(blockState))) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), blockState.func_177226_a(BlockThermalRedstone.REDSTONE_PROPERTY, (Comparable)((Object)MetaEnum.get(redstone))));
        }
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerThermalRedstone(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiThermalRedstone(player, this);
    }
}

