/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.sensors.thermal;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.api.map.DataMapType;
import com.builtbroken.atomic.content.ASItems;
import com.builtbroken.atomic.content.machines.sensors.thermal.TileEntityThermalRedstone;
import com.builtbroken.atomic.content.prefab.BlockPrefab;
import com.builtbroken.atomic.lib.MetaEnum;
import com.builtbroken.atomic.map.events.MapSystemEvent;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class BlockThermalRedstone
extends BlockPrefab {
    public static final PropertyEnum<MetaEnum> REDSTONE_PROPERTY = PropertyEnum.func_177707_a((String)"redstone", MetaEnum.class, (Collection)Lists.newArrayList((Object[])MetaEnum.values()));

    public BlockThermalRedstone() {
        super(Material.field_151573_f);
        this.setRegistryName("atomicscience:sensor_thermal_redstone");
        this.func_149663_c("atomicscience:sensor.thermal.redstone");
        this.func_180632_j(this.func_176223_P().func_177226_a(REDSTONE_PROPERTY, (Comparable)((Object)MetaEnum.ZERO)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184586_b(hand).func_77973_b() == ASItems.itemHeatProbe) {
            return false;
        }
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)AtomicScience.INSTANCE, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return true;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return BlockThermalRedstone.getRedstoneValue(blockState);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return BlockThermalRedstone.getRedstoneValue(blockState);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(REDSTONE_PROPERTY, (Comparable)((Object)MetaEnum.get(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((MetaEnum)((Object)state.func_177229_b(REDSTONE_PROPERTY))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{REDSTONE_PROPERTY});
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityThermalRedstone();
    }

    protected static int getRedstoneValue(IBlockState blockState) {
        if (blockState.func_177227_a().contains(REDSTONE_PROPERTY)) {
            return ((MetaEnum)((Object)blockState.func_177229_b(REDSTONE_PROPERTY))).ordinal();
        }
        return 0;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHeatChanged(MapSystemEvent.OnValueChanged event) {
        TileEntity tile;
        IBlockState blockState;
        World world = event.world();
        if (world != null && !world.field_72995_K && event.type == DataMapType.THERMAL && world.func_175667_e(event.getPos()) && (blockState = world.func_180495_p(event.getPos())).func_177230_c() instanceof BlockThermalRedstone && (tile = world.func_175625_s(event.getPos())) instanceof TileEntityThermalRedstone) {
            ((TileEntityThermalRedstone)tile).updateRedstoneState(blockState, event.getNewValue());
        }
    }
}

