/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.reactor.fission.core;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.api.AtomicScienceAPI;
import com.builtbroken.atomic.api.item.IFuelRodItem;
import com.builtbroken.atomic.api.radiation.IRadiationSource;
import com.builtbroken.atomic.api.reactor.IFissionReactor;
import com.builtbroken.atomic.api.thermal.IThermalSource;
import com.builtbroken.atomic.content.ASBlocks;
import com.builtbroken.atomic.content.machines.TileEntityInventoryMachine;
import com.builtbroken.atomic.content.machines.pipe.reactor.pass.TileEntityRodPipe;
import com.builtbroken.atomic.content.machines.reactor.fission.controller.TileEntityReactorController;
import com.builtbroken.atomic.content.machines.reactor.fission.core.BlockReactorCell;
import com.builtbroken.atomic.content.machines.reactor.fission.core.ReactorStructureType;
import com.builtbroken.atomic.lib.inventory.ItemStackHandlerWrapper;
import com.builtbroken.atomic.map.data.node.MapDataSources;
import com.builtbroken.atomic.map.exposure.node.RadSourceTile;
import com.builtbroken.atomic.map.thermal.node.ThermalSource;
import com.builtbroken.atomic.map.thermal.node.ThermalSourceTile;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityReactorCell
extends TileEntityInventoryMachine<IItemHandlerModifiable>
implements IFissionReactor {
    public static final int SLOT_FUEL_ROD = 0;
    public boolean _renderFuel = false;
    public float _renderFuelLevel = 0.0f;
    public boolean isRunning = false;
    public boolean enabled = true;
    private int heatCache;
    private int radCache;
    private final RadSourceTile<TileEntityReactorCell> radiationSource = new RadSourceTile<TileEntityReactorCell>(this, () -> this.radCache, () -> this.isRunning);
    private final ThermalSource<TileEntityReactorCell> thermalSource = new ThermalSourceTile<TileEntityReactorCell>(this, () -> this.heatCache, () -> this.isRunning);

    @Override
    protected void firstTick(boolean isClient) {
        super.firstTick(isClient);
        this.updateStructureType();
        if (!isClient) {
            MapDataSources.addSource(this.getRadiationSource());
            MapDataSources.addSource(this.getHeatSource());
        }
    }

    @Override
    protected IItemHandlerModifiable createInternalInventory() {
        return new ItemStackHandler(this.inventorySize()){

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                this.validateSlotIndex(slot);
                ItemStack prev = this.getStackInSlot(slot);
                this.stacks.set(slot, (Object)stack);
                if (!(stack.func_77973_b() instanceof IFuelRodItem)) {
                    TileEntityReactorCell.this.isRunning = false;
                }
                if (!ItemStack.func_77989_b((ItemStack)prev, (ItemStack)stack)) {
                    TileEntityReactorCell.this.onSlotStackChanged(slot, prev, stack);
                    this.onContentsChanged(slot);
                }
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b() instanceof IFuelRodItem;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    @Nonnull
    protected IItemHandlerModifiable createInventory() {
        return new ItemStackHandlerWrapper(this.getInventory()){

            @Override
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack slot_stack;
                if (!(slot != 0 || (slot_stack = this.getStackInSlot(0)).func_77973_b() instanceof IFuelRodItem && ((IFuelRodItem)slot_stack.func_77973_b()).getFuelRodRuntime(slot_stack, TileEntityReactorCell.this) > 0)) {
                    return this.inventory.extractItem(slot, amount, simulate);
                }
                return this.inventory.extractItem(slot, amount, simulate);
            }
        };
    }

    @Override
    protected int inventorySize() {
        return 1;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == AtomicScienceAPI.THERMAL_CAPABILITY || capability == AtomicScienceAPI.RADIATION_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == AtomicScienceAPI.THERMAL_CAPABILITY) {
            return (T)this.thermalSource;
        }
        if (capability == AtomicScienceAPI.RADIATION_CAPABILITY) {
            return (T)this.radiationSource;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void update(int ticks, boolean isClient) {
        super.update(ticks, isClient);
        if (!isClient) {
            this.doRodMovement(ticks);
            this.doRunChecks(ticks);
            this.heatCache = this.getHeatGenerated();
            this.radCache = this.getRadioactiveMaterial();
        } else if (this.isRunning) {
            AtomicScience.sideProxy.spawnParticle("reactor:running", (double)this.xi() + 0.5, (double)this.yi() + 0.5, (double)this.zi() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    protected void doRunChecks(int ticks) {
        boolean prev_running = this.isRunning;
        if (this.canOperate()) {
            this.isRunning = true;
            this.consumeFuel(ticks);
            if (ticks % 20 == 0) {
                this.doOperationTick();
            }
        } else {
            this.isRunning = false;
        }
        if (prev_running != this.isRunning) {
            this.onRunStateChanged();
        }
        if (prev_running != this.isRunning || ticks % 20 == 0) {
            this.syncClientNextTick();
        }
    }

    protected void onRunStateChanged() {
    }

    protected void doRodMovement(int ticks) {
        IFuelRodItem fuelRod;
        if (ticks % 100 == 0 && (fuelRod = this.getFuelRod()) != null) {
            int runtime = fuelRod.getFuelRodRuntime(this.getFuelRodStack(), this);
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
            if (tile instanceof TileEntityReactorCell) {
                this.tryToMoveRod((TileEntityReactorCell)tile);
            } else if (this.isValidRodRelay(tile) && runtime > 0) {
                BlockPos pos = this.func_174877_v().func_177979_c(2);
                while (this.isValidRodRelay(tile)) {
                    tile = this.field_145850_b.func_175625_s(pos);
                    if (tile instanceof TileEntityReactorCell) {
                        this.tryToMoveRod((TileEntityReactorCell)tile);
                        break;
                    }
                    pos = pos.func_177977_b();
                }
            } else if (tile != null && runtime <= 0) {
                IItemHandler inventory;
                if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP) && (inventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) != null) {
                    for (int slot = 0; slot < inventory.getSlots() && !this.getFuelRodStack().func_190926_b(); ++slot) {
                        if (!inventory.isItemValid(slot, this.getFuelRodStack())) continue;
                        this.setFuelRod(inventory.insertItem(slot, this.getFuelRodStack(), false));
                    }
                }
                if (this.getFuelRod() == null && AtomicScience.runningAsDev) {
                    AtomicScience.logger.info(this + " ejected spent rod");
                }
            }
        }
    }

    protected boolean isValidRodRelay(TileEntity tile) {
        return tile instanceof TileEntityReactorController || tile instanceof TileEntityRodPipe;
    }

    protected void tryToMoveRod(TileEntityReactorCell cell) {
        if (cell.getFuelRod() != null) {
            int otherRunTime;
            int runTime = this.getFuelRuntime();
            if (runTime < (otherRunTime = cell.getFuelRuntime())) {
                ItemStack stack = cell.getFuelRodStack();
                cell.setFuelRod(this.getFuelRodStack());
                this.setFuelRod(stack);
                if (AtomicScience.runningAsDev) {
                    AtomicScience.logger.info(this + " switched rods with lower reactor");
                }
            }
        } else {
            cell.setFuelRod(this.getFuelRodStack());
            this.setFuelRod(ItemStack.field_190927_a);
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.info(this + " moved rod to lower reactor");
            }
        }
    }

    protected void doOperationTick() {
    }

    protected int getActualHeat(int heat) {
        return heat;
    }

    protected void consumeFuel(int ticks) {
        IFuelRodItem fuelRodItem = this.getFuelRod();
        if (fuelRodItem != null) {
            this.getInventory().setStackInSlot(0, fuelRodItem.onReactorTick(this, this.getFuelRodStack(), ticks, this.getFuelRuntime()));
        }
    }

    protected boolean canOperate() {
        return this.enabled && this.hasFuel() && this.getFuelRuntime() > 0;
    }

    protected void onSlotStackChanged(int slot, ItemStack prev_stack, ItemStack new_stack) {
        this.func_70296_d();
        if (!this.canOperate()) {
            this.isRunning = false;
            this._renderFuel = false;
            this._renderFuelLevel = 0.0f;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        MapDataSources.removeSource(this.getRadiationSource());
        MapDataSources.removeSource(this.getHeatSource());
    }

    public void onChunkUnload() {
        this.resetSources();
    }

    public void resetSources() {
        this.getRadiationSource().disconnectMapData();
        this.getRadiationSource().clearMapData();
        this.getHeatSource().disconnectMapData();
        this.getHeatSource().clearMapData();
    }

    public boolean hasFuel() {
        return this.getFuelRod() != null;
    }

    public int getFuelRuntime() {
        IFuelRodItem fuelRod = this.getFuelRod();
        if (fuelRod != null) {
            return fuelRod.getFuelRodRuntime(this.getFuelRodStack(), this);
        }
        return 0;
    }

    public int getMaxFuelRuntime() {
        IFuelRodItem fuelRod = this.getFuelRod();
        if (fuelRod != null) {
            return fuelRod.getMaxFuelRodRuntime(this.getFuelRodStack(), this);
        }
        return 0;
    }

    @Override
    public IFuelRodItem getFuelRod() {
        ItemStack stack = this.getFuelRodStack();
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IFuelRodItem ? (IFuelRodItem)stack.func_77973_b() : null;
    }

    public void setFuelRod(ItemStack stack) {
        this.getInventory().setStackInSlot(0, stack);
    }

    @Override
    public ItemStack getFuelRodStack() {
        return this.getInventory().getStackInSlot(0);
    }

    public int getRadioactiveMaterial() {
        IFuelRodItem fuelRod = this.getFuelRod();
        if (fuelRod != null) {
            return fuelRod.getRadioactiveMaterial(this.getFuelRodStack(), this);
        }
        return 0;
    }

    public int getHeatGenerated() {
        IFuelRodItem fuelRodItem = this.getFuelRod();
        if (fuelRodItem != null) {
            return this.getActualHeat(fuelRodItem.getHeatOutput(this.getFuelRodStack(), this));
        }
        return 0;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return slot == 0 && stack.func_77973_b() instanceof IFuelRodItem;
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        if (0 == slot) {
            if (stack.func_77973_b() instanceof IFuelRodItem) {
                return ((IFuelRodItem)stack.func_77973_b()).getFuelRodRuntime(stack, this) <= 0;
            }
            return true;
        }
        return false;
    }

    public float getFuelRenderLevel() {
        if (this.isServer()) {
            return (float)this.getFuelRuntime() / (float)this.getMaxFuelRuntime();
        }
        return this._renderFuelLevel;
    }

    @Override
    protected void writeDescPacket(List<Object> dataList, EntityPlayer player) {
        super.writeDescPacket(dataList, player);
        dataList.add(this.isRunning || this.canOperate());
        dataList.add(this.hasFuel());
        dataList.add(Float.valueOf(this.getFuelRenderLevel()));
    }

    @Override
    protected void readDescPacket(ByteBuf buf, EntityPlayer player) {
        super.readDescPacket(buf, player);
        this.isRunning = buf.readBoolean();
        this._renderFuel = buf.readBoolean();
        this._renderFuelLevel = buf.readFloat();
    }

    public void updateStructureType() {
        IBlockState blockAbove = this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a());
        IBlockState blockBelow = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b());
        if (this.canConnect(blockAbove) && this.canConnect(blockBelow)) {
            this.setStructureType(ReactorStructureType.CORE_MIDDLE);
        } else if (this.canConnect(blockBelow)) {
            this.setStructureType(ReactorStructureType.CORE_TOP);
        } else if (this.canConnect(blockAbove)) {
            this.setStructureType(ReactorStructureType.CORE_BOTTOM);
        } else {
            this.setStructureType(ReactorStructureType.CORE);
        }
    }

    public void setStructureType(ReactorStructureType structureType) {
        ReactorStructureType type;
        IBlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (blockState.func_177228_b().containsKey((Object)BlockReactorCell.REACTOR_STRUCTURE_TYPE) && (type = (ReactorStructureType)((Object)blockState.func_177229_b((IProperty)BlockReactorCell.REACTOR_STRUCTURE_TYPE))) != structureType) {
            this.field_145850_b.func_175656_a(this.field_174879_c, blockState.func_177226_a((IProperty)BlockReactorCell.REACTOR_STRUCTURE_TYPE, (Comparable)((Object)structureType)));
        }
    }

    public ReactorStructureType getStructureType() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (blockState.func_177228_b().containsKey((Object)BlockReactorCell.REACTOR_STRUCTURE_TYPE)) {
            return (ReactorStructureType)((Object)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockReactorCell.REACTOR_STRUCTURE_TYPE));
        }
        return ReactorStructureType.CORE;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private boolean canConnect(IBlockState block) {
        return block.func_177230_c() == ASBlocks.blockReactorCell || block.func_177230_c() == ASBlocks.blockReactorController || block.func_177230_c() == ASBlocks.blockRodPipe || block.func_177230_c() == ASBlocks.blockRodPipeInv;
    }

    @Override
    public IRadiationSource getRadiationSource() {
        return this.radiationSource;
    }

    @Override
    public IThermalSource getHeatSource() {
        return this.thermalSource;
    }

    public String toString() {
        return "ReactorCell[W: " + this.worldName() + " | D: " + this.dim() + " | Pos(" + this.xi() + ", " + this.yi() + ", " + this.zi() + ")]@" + this.hashCode();
    }

    public boolean hasFastRenderer() {
        return true;
    }
}

