/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.reactor.fission.core;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.content.machines.reactor.fission.core.PropertyReactorState;
import com.builtbroken.atomic.content.machines.reactor.fission.core.ReactorStructureType;
import com.builtbroken.atomic.content.machines.reactor.fission.core.TileEntityReactorCell;
import com.builtbroken.atomic.content.prefab.BlockPrefab;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockReactorCell
extends BlockPrefab {
    public static final PropertyReactorState REACTOR_STRUCTURE_TYPE = new PropertyReactorState();

    public BlockReactorCell() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)REACTOR_STRUCTURE_TYPE, (Comparable)((Object)ReactorStructureType.CORE)));
        this.func_149647_a(AtomicScience.creativeTab);
        this.func_149663_c("atomicscience:reactor.cell");
        this.setRegistryName("atomicscience:reactor_cell");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityReactorCell();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityReactorCell) {
            TileEntityReactorCell reactorCell = (TileEntityReactorCell)tileEntity;
            ItemStack heldItem = player.func_184586_b(hand);
            if (!heldItem.func_190926_b()) {
                if (heldItem.func_77973_b() == Items.field_151055_y) {
                    if (!world.field_72995_K) {
                        int nodes;
                        player.func_145747_a((ITextComponent)new TextComponentString("Fuel: " + reactorCell.getFuelRuntime()));
                        if (reactorCell.getHeatSource().getCurrentNodes() != null) {
                            nodes = reactorCell.getHeatSource().getCurrentNodes().size();
                            int heat = reactorCell.getHeatSource().getHeatGenerated();
                            player.func_145747_a((ITextComponent)new TextComponentString(String.format("Thermal: %,dn %,dh", nodes, heat)));
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString("No thermal nodes"));
                        }
                        if (reactorCell.getRadiationSource().getCurrentNodes() != null) {
                            nodes = reactorCell.getRadiationSource().getCurrentNodes().size();
                            int mat = reactorCell.getRadiationSource().getRadioactiveMaterial();
                            player.func_145747_a((ITextComponent)new TextComponentString(String.format("Radiation: %,dn %,dr", nodes, mat)));
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString("No radiation nodes"));
                        }
                    }
                    return true;
                }
                if (reactorCell.isItemValidForSlot(0, heldItem)) {
                    if (!world.field_72995_K && reactorCell.getInventory().getStackInSlot(0).func_190926_b()) {
                        ItemStack copy = heldItem.func_77979_a(1);
                        reactorCell.getInventory().setStackInSlot(0, copy);
                        if (heldItem.func_190916_E() <= 0) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        } else {
                            player.func_184611_a(hand, heldItem);
                        }
                        player.field_71069_bz.func_75142_b();
                    }
                    return true;
                }
            } else if (player.func_70093_af()) {
                if (!world.field_72995_K && !reactorCell.getInventory().getStackInSlot(0).func_190926_b()) {
                    player.func_184611_a(hand, reactorCell.getInventory().getStackInSlot(0));
                    reactorCell.getInventory().setStackInSlot(0, ItemStack.field_190927_a);
                    player.field_71069_bz.func_75142_b();
                } else if (world.field_72995_K) {
                    reactorCell._renderFuel = false;
                    reactorCell._renderFuelLevel = 0.0f;
                }
                return true;
            }
        }
        return false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityReactorCell) {
            ((TileEntityReactorCell)tileEntity).updateStructureType();
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityReactorCell) {
            ((TileEntityReactorCell)tileEntity).updateStructureType();
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{REACTOR_STRUCTURE_TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)REACTOR_STRUCTURE_TYPE, (Comparable)((Object)ReactorStructureType.get(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((ReactorStructureType)((Object)state.func_177229_b((IProperty)REACTOR_STRUCTURE_TYPE))).ordinal();
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }
}

