/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.reactor.fission.controller;

import com.builtbroken.atomic.content.machines.pipe.reactor.inv.TileEntityRodPipeInv;
import com.builtbroken.atomic.content.machines.pipe.reactor.pass.TileEntityRodPipe;
import com.builtbroken.atomic.content.machines.reactor.fission.controller.ControllerState;
import com.builtbroken.atomic.content.machines.reactor.fission.core.TileEntityReactorCell;
import com.builtbroken.atomic.content.prefab.TileEntityActive;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityReactorController
extends TileEntityActive {
    public String stackID;
    public String stackName;
    private TileEntityReactorCell[] cells;
    private boolean inErrorState = false;
    private boolean refreshStack = true;
    private boolean enableReactors = true;
    public ControllerState controllerState = ControllerState.OFF;

    @Override
    protected void update(int ticks, boolean isClient) {
        super.update(ticks, isClient);
        if (!isClient) {
            if (this.cells == null || this.refreshStack || ticks % 20 == 0) {
                this.doRefreshStack();
            }
            if (ticks % 3 == 0) {
                boolean enabled = this.shouldEnableReactors();
                TileEntityReactorCell[] cells = this.getReactorCells();
                if (cells != null) {
                    for (TileEntityReactorCell cell : cells) {
                        cell.enabled = enabled;
                    }
                }
                ControllerState prev = this.controllerState;
                ControllerState controllerState = this.controllerState = enabled ? ControllerState.ON : ControllerState.OFF;
                if (prev != this.controllerState) {
                    this.sendDescPacket();
                }
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        TileEntity tile;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (tile = this.getTileBelow()) != null) {
            return tile.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        TileEntity tile;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (tile = this.getTileBelow()) != null) {
            return (T)tile.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    private final TileEntity getTileBelow() {
        return this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
    }

    public void setReactorsEnabled(boolean enabled) {
        this.enableReactors = enabled;
    }

    public boolean areReactorsEnabled() {
        return this.enableReactors;
    }

    protected boolean shouldEnableReactors() {
        return this.enableReactors && !this.world().func_175640_z(this.func_174877_v());
    }

    protected void doRefreshStack() {
        TileEntity tileEntity;
        this.inErrorState = false;
        this.refreshStack = false;
        this.cells = null;
        ArrayList<TileEntityReactorCell> reactorCellList = new ArrayList<TileEntityReactorCell>();
        BlockPos pos = this.func_174877_v().func_177984_a();
        while (pos.func_177956_o() < this.field_145850_b.func_72800_K()) {
            tileEntity = this.field_145850_b.func_175625_s(pos);
            if (tileEntity instanceof TileEntityReactorCell) {
                reactorCellList.add((TileEntityReactorCell)tileEntity);
            } else {
                if (tileEntity instanceof TileEntityReactorController) {
                    this.inErrorState = true;
                    return;
                }
                if (!(tileEntity instanceof TileEntityRodPipe) && !(tileEntity instanceof TileEntityRodPipeInv)) break;
            }
            pos = pos.func_177984_a();
        }
        pos = this.func_174877_v().func_177977_b();
        while (pos.func_177956_o() > 0) {
            tileEntity = this.field_145850_b.func_175625_s(pos);
            if (tileEntity instanceof TileEntityReactorCell) {
                reactorCellList.add((TileEntityReactorCell)tileEntity);
            } else {
                if (tileEntity instanceof TileEntityReactorController) {
                    this.inErrorState = true;
                    return;
                }
                if (!(tileEntity instanceof TileEntityRodPipe) && !(tileEntity instanceof TileEntityRodPipeInv)) break;
            }
            pos = pos.func_177977_b();
        }
        this.cells = reactorCellList.toArray(new TileEntityReactorCell[reactorCellList.size()]);
    }

    public boolean isInErrorState() {
        return this.inErrorState;
    }

    public TileEntityReactorCell[] getReactorCells() {
        return this.cells;
    }

    public void markForRefresh() {
        this.refreshStack = true;
    }

    public int getCellCount() {
        return this.getReactorCells() != null ? this.getReactorCells().length : 0;
    }

    @Override
    protected void writeDescPacket(List<Object> dataList, EntityPlayer player) {
        super.writeDescPacket(dataList, player);
        dataList.add(this.controllerState.ordinal());
    }

    @Override
    protected void readDescPacket(ByteBuf buf, EntityPlayer player) {
        super.readDescPacket(buf, player);
        ControllerState prev = this.controllerState;
        this.controllerState = ControllerState.get(buf.readInt());
        if (prev != this.controllerState) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public String toString() {
        return "ReactorController[W: " + this.worldName() + " | D: " + this.dim() + " | Pos(" + this.xi() + ", " + this.yi() + ", " + this.zi() + ")]@" + this.hashCode();
    }
}

