/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.reactor.fission.controller;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.content.machines.reactor.fission.controller.ControllerState;
import com.builtbroken.atomic.content.machines.reactor.fission.controller.TileEntityReactorController;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockReactorController
extends BlockContainer {
    public static final PropertyEnum<ControllerState> STATE_PROPERTY = PropertyEnum.func_177707_a((String)"state", ControllerState.class, (Collection)Lists.newArrayList((Object[])ControllerState.values()));

    public BlockReactorController() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(AtomicScience.creativeTab);
        this.func_149663_c("atomicscience:reactor.controller");
        this.setRegistryName("atomicscience:reactor_controller");
        this.func_180632_j(this.func_176223_P().func_177226_a(STATE_PROPERTY, (Comparable)((Object)ControllerState.OFF)));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityReactorController();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        ItemStack heldItem = player.func_184586_b(hand);
        if (!(heldItem.func_77973_b() instanceof ItemBlock) && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityReactorController) {
            TileEntityReactorController controller = (TileEntityReactorController)tileEntity;
            if (!world.field_72995_K) {
                if (controller.isInErrorState()) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(this.func_149739_a() + ".error.state", new Object[0]));
                } else {
                    if (heldItem != null && heldItem.func_77973_b() == Items.field_151055_y) {
                        controller.setReactorsEnabled(!controller.areReactorsEnabled());
                        player.func_145747_a((ITextComponent)new TextComponentString(controller.areReactorsEnabled() ? "Reactors are set into enabled state" : "Reactors are set into disabled state"));
                        return true;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(this.func_149739_a() + ".cell.count", new Object[]{"" + controller.getCellCount()}));
                }
            }
            return true;
        }
        return false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityReactorController) {
            ((TileEntityReactorController)tileEntity).markForRefresh();
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return true;
    }

    public IBlockState func_176221_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityReactorController) {
            ControllerState controllerState = ((TileEntityReactorController)tile).controllerState;
            return blockState.func_177226_a(STATE_PROPERTY, (Comparable)((Object)controllerState));
        }
        return blockState;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STATE_PROPERTY});
    }
}

