/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.processing.extractor;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.config.content.ConfigContent;
import com.builtbroken.atomic.content.items.wrench.WrenchColor;
import com.builtbroken.atomic.content.items.wrench.WrenchMode;
import com.builtbroken.atomic.content.machines.processing.ProcessorRecipeHandler;
import com.builtbroken.atomic.content.machines.processing.TileEntityProcessingMachine;
import com.builtbroken.atomic.content.machines.processing.extractor.gui.ContainerChemExtractor;
import com.builtbroken.atomic.content.machines.processing.extractor.gui.GuiChemExtractor;
import com.builtbroken.atomic.content.machines.processing.extractor.inventory.InventoryChemExtractor;
import com.builtbroken.atomic.content.machines.processing.extractor.inventory.PipeInventoryExtractor;
import com.builtbroken.atomic.content.recipes.ProcessingRecipeList;
import com.builtbroken.atomic.content.recipes.chem.RecipeChemExtractor;
import com.builtbroken.atomic.lib.SideSettings;
import com.builtbroken.atomic.lib.fluid.FluidSideWrapper;
import com.builtbroken.atomic.lib.gui.IGuiTile;
import com.builtbroken.atomic.network.IPacket;
import com.builtbroken.atomic.network.netty.PacketSystem;
import com.builtbroken.atomic.network.packet.client.PacketSpawnParticle;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityChemExtractor
extends TileEntityProcessingMachine<IItemHandlerModifiable, TileEntityChemExtractor, RecipeChemExtractor>
implements IGuiTile {
    public static final int SLOT_FLUID_INPUT = 0;
    public static final int SLOT_ITEM_INPUT = 1;
    public static final int SLOT_ITEM_OUTPUT = 2;
    public static final int SLOT_BATTERY = 3;
    public static final int SLOT_FLUID_OUTPUT = 4;
    public static final int INVENTORY_SIZE = 5;
    public static final int[] INPUT_SLOTS = new int[]{1};
    public static final int[] OUTPUT_SLOTS = new int[]{2};
    public static final int[] ACCESSIBLE_SLOTS = new int[]{1, 2};
    public static int PROCESSING_TIME = 100;
    public ItemStack nextRandomOutput = ItemStack.field_190927_a;
    private final FluidTank inputTank;
    private final FluidTank outputTank;
    private final SideSettings inputTankSideSettings = new SideSettings(true);
    private final SideSettings outputTankSideSettings = new SideSettings(false);
    private final FluidSideWrapper[] fluidSideWrappers = new FluidSideWrapper[6];

    public TileEntityChemExtractor() {
        this.inputTank = new FluidTank(10000);
        this.outputTank = new FluidTank(10000);
        for (EnumFacing side : EnumFacing.values()) {
            this.fluidSideWrappers[side.ordinal()] = new FluidSideWrapper(side);
            this.fluidSideWrappers[side.ordinal()].add(this.inputTankSideSettings, (IFluidTank)this.inputTank, false);
            this.fluidSideWrappers[side.ordinal()].add(this.outputTankSideSettings, (IFluidTank)this.outputTank, true);
        }
    }

    @Override
    public void update(int ticks, boolean isClient) {
        super.update(ticks, isClient);
        if (!isClient) {
            this.drainBattery(3);
        }
    }

    @Override
    protected IItemHandlerModifiable createInventory() {
        return new PipeInventoryExtractor(this);
    }

    @Override
    protected IItemHandlerModifiable createInternalInventory() {
        return new InventoryChemExtractor(this);
    }

    @Override
    protected int inventorySize() {
        return 5;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidSideWrappers[facing.ordinal()].hasTank();
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidSideWrappers[facing.ordinal()];
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void onProcessed() {
        if (this.isServer()) {
            PacketSpawnParticle packetSpawnParticle = new PacketSpawnParticle(this.field_145850_b.field_73011_w.getDimension(), (double)this.xi() + 0.5, (double)this.yi() + 0.5, (double)this.zi() + 0.5, 0.0, 0.0, 0.0, "extractor:complete");
            PacketSystem.INSTANCE.sendToAllAround((IPacket)packetSpawnParticle, this.field_145850_b, this, 30.0);
        }
    }

    @Override
    protected void doEffects(int ticks) {
        if ((double)this.field_145850_b.field_73012_v.nextFloat() > 0.3) {
            AtomicScience.sideProxy.spawnParticle("extractor:running", (double)this.xi() + 0.5, (double)this.yi() + 0.5, (double)this.zi() + 0.5, this.getFacingDirection().ordinal(), 0.0, 0.0);
        }
    }

    @Override
    protected void preProcess(int ticks) {
        this.fillTank(0, (IFluidTank)this.getInputTank());
    }

    @Override
    protected int getProcessingTime() {
        return PROCESSING_TIME;
    }

    @Override
    protected void postProcess(int ticks) {
        this.outputFluids(4, (IFluidTank)this.getOutputTank());
        this.outputFluidToTiles((IFluidTank)this.getOutputTank(), f -> this.outputTankSideSettings.get((EnumFacing)f));
    }

    @Override
    public ProcessingRecipeList getRecipeList() {
        return ProcessorRecipeHandler.INSTANCE.chemExtractorProcessingRecipe;
    }

    @Override
    protected void onSlotStackChanged(ItemStack prev, ItemStack stack, int slot) {
        if (this.isServer() && slot == 1) {
            this.checkRecipe();
        }
        super.onSlotStackChanged(prev, stack, slot);
    }

    @Override
    public void onWrench(WrenchMode type, WrenchColor color, EnumFacing side, EntityPlayer player) {
        if (type == WrenchMode.FLUID && side != null) {
            if (color == WrenchColor.GREEN) {
                this.outputTankSideSettings.toggle(side);
                player.func_145747_a((ITextComponent)new TextComponentString(this.outputTankSideSettings.get(side) ? "Green tank set to output on side" : "Green tank set to ignore side"));
            } else if (color == WrenchColor.BLUE) {
                this.inputTankSideSettings.toggle(side);
                player.func_145747_a((ITextComponent)new TextComponentString(this.inputTankSideSettings.get(side) ? "Blue tank set to input on side" : "Blue tank set to ignore side"));
            }
        }
    }

    public FluidTank getInputTank() {
        return this.inputTank;
    }

    public FluidTank getOutputTank() {
        return this.outputTank;
    }

    @Override
    public int getEnergyUsage() {
        return ConfigContent.POWER_USAGE.EXTRACTOR;
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerChemExtractor(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiChemExtractor(player, this);
    }

    @Override
    protected void writeGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeGuiPacket(dataList, player);
        dataList.add(this.getInputTank());
        dataList.add(this.getOutputTank());
    }

    @Override
    protected void readGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readGuiPacket(buf, player);
        this.getInputTank().readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
        this.getOutputTank().readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("outputTank", (NBTBase)this.getOutputTank().writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("inputTank", (NBTBase)this.getInputTank().writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("outputTankSides", (NBTBase)this.outputTankSideSettings.save(new NBTTagCompound()));
        nbt.func_74782_a("inputTankSides", (NBTBase)this.inputTankSideSettings.save(new NBTTagCompound()));
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getOutputTank().readFromNBT(nbt.func_74775_l("outputTank"));
        this.getInputTank().readFromNBT(nbt.func_74775_l("inputTank"));
        this.outputTankSideSettings.load(nbt.func_74775_l("outputTankSides"));
        this.inputTankSideSettings.load(nbt.func_74775_l("inputTankSides"));
    }
}

