/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.processing.boiler;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.config.content.ConfigContent;
import com.builtbroken.atomic.content.items.wrench.WrenchColor;
import com.builtbroken.atomic.content.items.wrench.WrenchMode;
import com.builtbroken.atomic.content.machines.processing.ProcessorRecipeHandler;
import com.builtbroken.atomic.content.machines.processing.TileEntityProcessingMachine;
import com.builtbroken.atomic.content.machines.processing.boiler.gui.ContainerChemBoiler;
import com.builtbroken.atomic.content.machines.processing.boiler.gui.GuiChemBoiler;
import com.builtbroken.atomic.content.machines.processing.boiler.inventory.InventoryChemBoiler;
import com.builtbroken.atomic.content.machines.processing.boiler.inventory.PipeInventoryChemBoiler;
import com.builtbroken.atomic.content.recipes.ProcessingRecipeList;
import com.builtbroken.atomic.content.recipes.chem.RecipeChemBoiler;
import com.builtbroken.atomic.lib.SideSettings;
import com.builtbroken.atomic.lib.fluid.FluidSideWrapper;
import com.builtbroken.atomic.lib.gui.IGuiTile;
import com.builtbroken.atomic.network.IPacket;
import com.builtbroken.atomic.network.netty.PacketSystem;
import com.builtbroken.atomic.network.packet.client.PacketSpawnParticle;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityChemBoiler
extends TileEntityProcessingMachine<IItemHandlerModifiable, TileEntityChemBoiler, RecipeChemBoiler>
implements IGuiTile {
    public static final int SLOT_FLUID_INPUT = 0;
    public static final int SLOT_ITEM_INPUT = 1;
    public static final int SLOT_ITEM_OUTPUT = 2;
    public static final int SLOT_BATTERY = 3;
    public static final int SLOT_WASTE_FLUID = 4;
    public static final int SLOT_HEX_FLUID = 5;
    public static final int INVENTORY_SIZE = 6;
    public static int PROCESSING_TIME = 100;
    private final FluidTank blueTank;
    private final FluidTank greenTank;
    private final FluidTank yellowTank;
    private final SideSettings blueTankSideSettings = new SideSettings(true);
    private final SideSettings greenTankSideSettings = new SideSettings(false);
    private final SideSettings yellowTankSideSettings = new SideSettings(false);
    private final FluidSideWrapper[] fluidSideWrappers = new FluidSideWrapper[6];

    public TileEntityChemBoiler() {
        this.blueTank = new FluidTank(10000);
        this.greenTank = new FluidTank(10000);
        this.yellowTank = new FluidTank(10000);
        for (EnumFacing side : EnumFacing.values()) {
            this.fluidSideWrappers[side.ordinal()] = new FluidSideWrapper(side);
            this.fluidSideWrappers[side.ordinal()].add(this.blueTankSideSettings, (IFluidTank)this.blueTank, false);
            this.fluidSideWrappers[side.ordinal()].add(this.greenTankSideSettings, (IFluidTank)this.greenTank, true);
            this.fluidSideWrappers[side.ordinal()].add(this.yellowTankSideSettings, (IFluidTank)this.yellowTank, true);
        }
    }

    @Override
    public void update(int ticks, boolean isClient) {
        super.update(ticks, isClient);
        if (!isClient) {
            this.drainBattery(3);
        }
    }

    @Override
    protected IItemHandlerModifiable createInventory() {
        return new PipeInventoryChemBoiler(this);
    }

    @Override
    protected IItemHandlerModifiable createInternalInventory() {
        return new InventoryChemBoiler(this);
    }

    @Override
    protected int inventorySize() {
        return 6;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidSideWrappers[facing.ordinal()].hasTank();
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidSideWrappers[facing.ordinal()];
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void onProcessed() {
        if (this.isServer()) {
            PacketSpawnParticle packetSpawnParticle = new PacketSpawnParticle(this.field_145850_b.field_73011_w.getDimension(), (double)this.xi() + 0.5, (double)this.yi() + 0.5, (double)this.zi() + 0.5, 0.0, 0.0, 0.0, "boiler:complete");
            PacketSystem.INSTANCE.sendToAllAround((IPacket)packetSpawnParticle, this.field_145850_b, this, 30.0);
        }
    }

    @Override
    protected void doEffects(int ticks) {
        if ((double)this.field_145850_b.field_73012_v.nextFloat() > 0.3) {
            AtomicScience.sideProxy.spawnParticle("boiler:running", (double)this.xi() + 0.5, (double)this.yi() + 0.5, (double)this.zi() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void preProcess(int ticks) {
        this.fillTank(0, (IFluidTank)this.getBlueTank());
    }

    @Override
    protected int getProcessingTime() {
        return PROCESSING_TIME;
    }

    @Override
    protected void postProcess(int ticks) {
        this.outputFluids(4, (IFluidTank)this.getGreenTank());
        this.outputFluids(5, (IFluidTank)this.getYellowTank());
        this.outputFluidToTiles((IFluidTank)this.getGreenTank(), f -> this.greenTankSideSettings.get((EnumFacing)f));
        this.outputFluidToTiles((IFluidTank)this.getYellowTank(), f -> this.yellowTankSideSettings.get((EnumFacing)f));
    }

    @Override
    public ProcessingRecipeList getRecipeList() {
        return ProcessorRecipeHandler.INSTANCE.chemBoilerProcessingRecipe;
    }

    @Override
    protected void onSlotStackChanged(ItemStack prev, ItemStack stack, int slot) {
        if (this.isServer() && slot == 1) {
            this.checkRecipe();
        }
        super.onSlotStackChanged(prev, stack, slot);
    }

    @Override
    public void onWrench(WrenchMode type, WrenchColor color, EnumFacing side, EntityPlayer player) {
        if (type == WrenchMode.FLUID && side != null) {
            if (color == WrenchColor.GREEN) {
                this.greenTankSideSettings.toggle(side);
                player.func_145747_a((ITextComponent)new TextComponentString(this.greenTankSideSettings.get(side) ? "Green tank set to output on side" : "Green tank set to ignore side"));
            } else if (color == WrenchColor.YELLOW) {
                this.yellowTankSideSettings.toggle(side);
                player.func_145747_a((ITextComponent)new TextComponentString(this.yellowTankSideSettings.get(side) ? "Yellow tank set to output on side" : "Yellow tank set to ignore side"));
            } else if (color == WrenchColor.BLUE) {
                this.blueTankSideSettings.toggle(side);
                player.func_145747_a((ITextComponent)new TextComponentString(this.blueTankSideSettings.get(side) ? "Blue tank set to input on side" : "Blue tank set to ignore side"));
            }
        }
    }

    public FluidTank getBlueTank() {
        return this.blueTank;
    }

    public FluidTank getGreenTank() {
        return this.greenTank;
    }

    public FluidTank getYellowTank() {
        return this.yellowTank;
    }

    @Override
    public int getEnergyUsage() {
        return ConfigContent.POWER_USAGE.BOILER;
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerChemBoiler(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiChemBoiler(player, this);
    }

    @Override
    protected void writeGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeGuiPacket(dataList, player);
        dataList.add(this.getBlueTank());
        dataList.add(this.getGreenTank());
        dataList.add(this.getYellowTank());
    }

    @Override
    protected void readGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readGuiPacket(buf, player);
        this.getBlueTank().readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
        this.getGreenTank().readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
        this.getYellowTank().readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("wasteTank", (NBTBase)this.getGreenTank().writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("inputTank", (NBTBase)this.getBlueTank().writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("hexTank", (NBTBase)this.getYellowTank().writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("wasteTankSides", (NBTBase)this.greenTankSideSettings.save(new NBTTagCompound()));
        nbt.func_74782_a("hexTankSides", (NBTBase)this.yellowTankSideSettings.save(new NBTTagCompound()));
        nbt.func_74782_a("waterTankSides", (NBTBase)this.blueTankSideSettings.save(new NBTTagCompound()));
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getGreenTank().readFromNBT(nbt.func_74775_l("wasteTank"));
        this.getBlueTank().readFromNBT(nbt.func_74775_l("inputTank"));
        this.getYellowTank().readFromNBT(nbt.func_74775_l("hexTank"));
        this.greenTankSideSettings.load(nbt.func_74775_l("wasteTankSides"));
        this.yellowTankSideSettings.load(nbt.func_74775_l("hexTankSides"));
        this.blueTankSideSettings.load(nbt.func_74775_l("waterTankSides"));
    }
}

