/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.processing;

import com.builtbroken.atomic.content.items.wrench.WrenchColor;
import com.builtbroken.atomic.content.items.wrench.WrenchMode;
import com.builtbroken.atomic.content.machines.TileEntityPowerInvMachine;
import com.builtbroken.atomic.content.recipes.ProcessingRecipeList;
import com.builtbroken.atomic.content.recipes.RecipeProcessing;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class TileEntityProcessingMachine<I extends IItemHandlerModifiable, H extends TileEntityProcessingMachine, R extends RecipeProcessing<H>>
extends TileEntityPowerInvMachine<I> {
    public static final String NBT_PROCESSING_RPOGRESS = "processingProgress";
    boolean processing = false;
    public int processTimer = 0;
    EnumFacing _facingDirectionCache;
    float _processingAnimationRotationPrev = 0.0f;
    float _processingAnimationRotation = 0.0f;

    @Override
    public void update(int ticks, boolean isClient) {
        super.update(ticks, isClient);
        if (this.checkEnergyExtract()) {
            if (this.isServer()) {
                this.preProcess(ticks);
                this.process(ticks);
                this.postProcess(ticks);
            } else if (this.processTimer > 0) {
                this.doAnimation(ticks);
                this.doEffects(ticks);
            }
        }
    }

    protected void doAnimation(int ticks) {
        this._processingAnimationRotation += 5.0f;
        if (this._processingAnimationRotation > 360.0f) {
            this._processingAnimationRotation -= 360.0f;
            this._processingAnimationRotationPrev -= 360.0f;
        }
    }

    protected void doEffects(int ticks) {
    }

    public void onWrench(WrenchMode type, WrenchColor color, EnumFacing side, EntityPlayer player) {
    }

    protected void preProcess(int ticks) {
    }

    protected void process(int ticks) {
        if (this.processing) {
            this.extractEnergy();
            if (this.processTimer++ >= this.getProcessingTime()) {
                this.processTimer = 0;
                this.doProcess();
                this.checkRecipe();
            }
        } else if (ticks % 20 == 0) {
            this.checkRecipe();
        }
    }

    protected void onProcessed() {
    }

    protected abstract int getProcessingTime();

    protected void doProcess() {
        RecipeProcessing<TileEntityProcessingMachine> recipe = this.getRecipeList().getMatchingRecipe(this);
        if (recipe != null && recipe.applyRecipe(this)) {
            this.onProcessed();
        }
    }

    protected void checkRecipe() {
        this.processing = this.canProcess();
        if (!this.processing) {
            this.processTimer = 0;
        } else if (this.processTimer == 0) {
            this.processTimer = 1;
        }
        this.syncClientNextTick();
    }

    protected boolean canProcess() {
        return this.getRecipeList().getMatchingRecipe(this) != null;
    }

    protected abstract ProcessingRecipeList<H, R> getRecipeList();

    protected void postProcess(int ticks) {
    }

    public boolean hasSpaceInOutput(ItemStack insertStack, int slot) {
        return this.getInventory().insertItem(slot, insertStack, true).func_190926_b();
    }

    public void addToOutput(ItemStack insertStack, int slot) {
        this.getInventory().insertItem(slot, insertStack, false);
    }

    public boolean containsFluid(int slot) {
        return this.getFluid(slot) != null;
    }

    public boolean containsFluid(int slot, Fluid fluid) {
        FluidStack fluidStack = this.getFluid(slot);
        if (fluidStack != null) {
            return fluidStack.getFluid() == fluid;
        }
        return false;
    }

    public boolean isInputFluid(int slot) {
        return this.isInputFluid(this.getInventory().getStackInSlot(slot));
    }

    public boolean isInputFluid(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack != null) {
            return this.getRecipeList().isComponent(this, fluidStack.getFluid());
        }
        return false;
    }

    public FluidStack getFluid(int slot) {
        return this.getFluid(this.getInventory().getStackInSlot(slot));
    }

    public FluidStack getFluid(ItemStack itemStack) {
        IFluidHandler handler;
        if (!itemStack.func_190926_b() && itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (handler = (IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
            return handler.drain(Integer.MAX_VALUE, false);
        }
        return null;
    }

    public boolean isEmptyFluidContainer(int slot) {
        return this.isEmptyFluidContainer(this.getInventory().getStackInSlot(slot));
    }

    public boolean isEmptyFluidContainer(ItemStack itemStack) {
        if (itemStack != null && !itemStack.func_190926_b()) {
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)itemStack);
            if (handler != null) {
                FluidStack fluidStack = handler.drain(1, false);
                return fluidStack == null || fluidStack.amount <= 0;
            }
            return itemStack.func_77973_b() == Items.field_151133_ar;
        }
        return false;
    }

    protected void fillTank(int slot, IFluidTank inputTank) {
        FluidStack fluidStack;
        IFluidHandler handler;
        ItemStack itemStack = this.getInventory().getStackInSlot(slot);
        if (!itemStack.func_190926_b() && itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (handler = (IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null && (fluidStack = handler.drain(inputTank.getCapacity() - inputTank.getFluidAmount(), false)) != null && this.getRecipeList().isComponent(this, fluidStack.getFluid())) {
            int amount = inputTank.fill(fluidStack, true);
            handler.drain(amount, true);
            this.getInventory().setStackInSlot(slot, handler instanceof IFluidHandlerItem ? ((IFluidHandlerItem)handler).getContainer() : itemStack);
        }
    }

    protected void outputFluids(int slot, IFluidTank outputTank) {
        IFluidHandler handler;
        ItemStack itemStack = this.getInventory().getStackInSlot(slot);
        if (!itemStack.func_190926_b() && outputTank.getFluid() != null && itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (handler = (IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
            int fill = handler.fill(outputTank.getFluid(), true);
            outputTank.drain(fill, true);
            this.getInventory().setStackInSlot(slot, handler instanceof IFluidHandlerItem ? ((IFluidHandlerItem)handler).getContainer() : itemStack);
        }
    }

    protected void outputFluidToTiles(IFluidTank outputTank, Function<EnumFacing, Boolean> canUseSideFunction) {
        if (outputTank.getFluid() != null) {
            for (EnumFacing direction : EnumFacing.field_82609_l) {
                IFluidHandler handler;
                TileEntity tile;
                BlockPos pos;
                if (canUseSideFunction != null && !canUseSideFunction.apply(direction).booleanValue() || !this.field_145850_b.func_175667_e(pos = this.func_174877_v().func_177971_a(direction.func_176730_m())) || (tile = this.field_145850_b.func_175625_s(pos)) == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction) || (handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction)) == null) continue;
                int fill = handler.fill(outputTank.getFluid(), true);
                outputTank.drain(fill, true);
            }
        }
    }

    public boolean hasInputFluid(IFluidTank tank, Fluid fluid, int amount) {
        FluidStack inputFluidStack = tank.getFluid();
        return inputFluidStack != null && inputFluidStack.getFluid() == fluid && inputFluidStack.amount >= amount;
    }

    public boolean canOutputFluid(IFluidTank tank, Fluid fluid, int amount) {
        if (fluid != null && amount > 0) {
            if (tank.getFluid() != null) {
                int room = tank.getCapacity() - tank.getFluid().amount;
                return room >= amount && fluid == tank.getFluid().getFluid();
            }
            return tank.getCapacity() >= amount;
        }
        return false;
    }

    public boolean tankMatch(IFluidTank tank, FluidStack fluidStack) {
        if (fluidStack != null) {
            return tank.getFluid() != null && tank.getFluid().getFluid() == fluidStack.getFluid();
        }
        return false;
    }

    public boolean tankMatch(IFluidTank tank, Fluid fluid) {
        return tank.getFluid() != null && tank.getFluid().getFluid() == fluid;
    }

    public EnumFacing getFacingDirection() {
        if (this._facingDirectionCache == null) {
            this._facingDirectionCache = EnumFacing.func_82600_a((int)this.func_145832_p());
        }
        return this._facingDirectionCache;
    }

    public void func_70296_d() {
        if (this.isServer()) {
            this._facingDirectionCache = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float rotate(float delta) {
        this._processingAnimationRotationPrev = this._processingAnimationRotation + (this._processingAnimationRotation - this._processingAnimationRotationPrev) * delta;
        return this._processingAnimationRotationPrev;
    }

    @Override
    protected void writeGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeGuiPacket(dataList, player);
        dataList.add(this.processTimer);
    }

    @Override
    protected void readGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readGuiPacket(buf, player);
        this.processTimer = buf.readInt();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a(NBT_PROCESSING_RPOGRESS, this.processTimer);
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTimer = nbt.func_74762_e(NBT_PROCESSING_RPOGRESS);
    }

    @Override
    protected void writeDescPacket(List<Object> dataList, EntityPlayer player) {
        super.writeGuiPacket(dataList, player);
        dataList.add(this.processTimer);
    }

    @Override
    protected void readDescPacket(ByteBuf buf, EntityPlayer player) {
        super.readGuiPacket(buf, player);
        this.processTimer = buf.readInt();
    }
}

