/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.pipe.reactor.inv;

import com.builtbroken.atomic.api.item.IFuelRodItem;
import com.builtbroken.atomic.content.machines.pipe.reactor.inv.gui.ContainerRodPipe;
import com.builtbroken.atomic.content.machines.pipe.reactor.inv.gui.GuiRodPipe;
import com.builtbroken.atomic.content.machines.pipe.reactor.pass.TileEntityRodPipe;
import com.builtbroken.atomic.lib.gui.IGuiTile;
import com.builtbroken.atomic.lib.timer.TickTimer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityRodPipeInv
extends TileEntity
implements ITickable,
IGuiTile {
    public static final String NBT_INVENTORY = "inventory";
    public static final int SLOT_ROD = 0;
    private ItemStackHandler inventory;
    private final TickTimer inventoryMoveTimer = TickTimer.newSimple(10, ticks -> this.moveItems());
    private final List<EntityPlayer> playersGUI = new ArrayList<EntityPlayer>();

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.inventoryMoveTimer.tick();
        }
    }

    protected void moveItems() {
        IItemHandler inventory;
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
        if (tile != null && TileEntityRodPipe.canPipeSupport(tile) && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP) && (inventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) != null) {
            ItemStack stackToInsert = this.getItem().func_77946_l();
            for (int slot = 0; slot < inventory.getSlots() && !stackToInsert.func_190926_b(); ++slot) {
                if (!inventory.isItemValid(slot, stackToInsert)) continue;
                stackToInsert = inventory.insertItem(slot, stackToInsert, false);
            }
            this.setItem(stackToInsert);
        }
    }

    protected ItemStack getItem() {
        return this.getInventory().getStackInSlot(0);
    }

    protected void setItem(ItemStack stack) {
        this.getInventory().setStackInSlot(0, stack);
    }

    public ItemStackHandler getInventory() {
        if (this.inventory == null) {
            this.inventory = new ItemStackHandler(1){

                public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                    return stack.func_77973_b() instanceof IFuelRodItem;
                }

                public int getSlotLimit(int slot) {
                    return 1;
                }

                protected void onContentsChanged(int slot) {
                    TileEntityRodPipeInv.this.func_70296_d();
                }
            };
        }
        return this.inventory;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing == EnumFacing.UP && TileEntityRodPipe.canPipeSupport(capability)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.UP) {
            return (T)this.getInventory();
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerRodPipe(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiRodPipe(player, this);
    }

    @Override
    public Collection<EntityPlayer> getPlayersUsingGui() {
        return this.playersGUI;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.getInventory().deserializeNBT(compound.func_74775_l(NBT_INVENTORY));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a(NBT_INVENTORY, (NBTBase)this.getInventory().serializeNBT());
        return super.func_189515_b(compound);
    }
}

