/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.pipe.imp;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.content.prefab.TileEntityPrefab;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TileEntityDirectionalPipe
extends TileEntityPrefab {
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing != null && this.canSupportDirection(facing) && this.canSupport(capability)) {
            EnumFacing outputDirection = this.getOutDirection(facing);
            EnumFacing sideToAccess = outputDirection.func_176734_d();
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(outputDirection));
            if (tile instanceof TileEntityDirectionalPipe) {
                tile = ((TileEntityDirectionalPipe)tile).getTargetTile(capability, sideToAccess, this);
            }
            if (tile != null && this.canSupport(tile)) {
                boolean hasCap = tile.hasCapability(capability, sideToAccess);
                return hasCap;
            }
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && this.canSupportDirection(facing) && this.canSupport(capability)) {
            Object r;
            EnumFacing outputDirection = this.getOutDirection(facing);
            EnumFacing sideToAccess = outputDirection.func_176734_d();
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(outputDirection));
            if (tile instanceof TileEntityDirectionalPipe) {
                tile = ((TileEntityDirectionalPipe)tile).getTargetTile(capability, sideToAccess, this);
            }
            if (tile != null && this.canSupport(tile) && (r = tile.getCapability(capability, sideToAccess)) != null) {
                return (T)r;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    protected TileEntity getTargetTile(Capability capability, EnumFacing sideAccessed, TileEntity source) {
        if (this.canSupportDirection(sideAccessed) && this.canSupport(capability)) {
            EnumFacing outDirection = this.getOutDirection(sideAccessed);
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(outDirection));
            if (this.canSupport(tile)) {
                if (tile == source) {
                    if (AtomicScience.runningAsDev) {
                        AtomicScience.logger.error("TileEntityDirectionalPipe: Infinite loop detected from " + source + " to " + this);
                    }
                    return null;
                }
                if (tile instanceof TileEntityDirectionalPipe) {
                    EnumFacing sideToAccess = outDirection.func_176734_d();
                    return ((TileEntityDirectionalPipe)tile).getTargetTile(capability, sideToAccess, this);
                }
                return tile;
            }
        }
        return null;
    }

    protected EnumFacing getOutDirection(EnumFacing input) {
        return this.getDirection();
    }

    public abstract boolean canSupportDirection(EnumFacing var1);

    public abstract boolean canSupport(Capability var1);

    public boolean canSupport(TileEntity tileEntity) {
        return true;
    }
}

