/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.laser.emitter;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.config.content.ConfigContent;
import com.builtbroken.atomic.content.machines.accelerator.gun.TileEntityAcceleratorGun;
import com.builtbroken.atomic.content.machines.container.item.TileEntityItemContainer;
import com.builtbroken.atomic.content.machines.laser.booster.TileEntityLaserBooster;
import com.builtbroken.atomic.content.machines.laser.emitter.LaserModes;
import com.builtbroken.atomic.content.prefab.TileEntityMachine;
import com.builtbroken.atomic.lib.power.Battery;
import com.builtbroken.atomic.lib.timer.TickTimerConditional;
import com.builtbroken.atomic.lib.timer.TickTimerTileEntity;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileEntityLaserEmitter
extends TileEntityMachine {
    public static int MAX_RAY_DISTANCE = 5;
    public static final String NBT_BOOSTER_COUNT = "booster_count";
    public static final String NBT_ENERGY = "energy";
    public static final String NBT_LASER_MODE = "laser_mode";
    public int boosterCount;
    public int cooldown = 0;
    public boolean sharingBoosters = false;
    public boolean readyToFire = false;
    public boolean shouldFire = false;
    public boolean fireOverride = false;
    public boolean hasRedstone = false;
    public boolean doFireLaser = false;
    public final Battery battery = new Battery(() -> ConfigContent.LASER.ENERGY_PER_BOOSTER * this.boosterCount);
    private LaserModes _laserMode = LaserModes.NORMAL;

    public TileEntityLaserEmitter() {
        this.tickServer.add(TickTimerTileEntity.newSimple(20, tick -> this.scanForBoosters()));
        this.tickServer.add(TickTimerTileEntity.newSimple(3, tick -> this.checkForRedstone()));
        this.tickServer.add(TickTimerTileEntity.newSimple(tick -> this.checkMachineState()));
        this.tickServer.add(TickTimerConditional.newTrigger(() -> ConfigContent.LASER.LASER_FIRING_DELAY, tick -> this.fire(), () -> this.getLaserMode() == LaserModes.NORMAL && this.canFireLaser()));
        this.tickServer.add(TickTimerTileEntity.newConditional(1, tick -> this.fire(), () -> this.getLaserMode() == LaserModes.FIELD && this.canFireLaser()));
        this.tickClient.add(TickTimerTileEntity.newConditional(3, tick -> this.spawnReadyToFireParticles(), () -> this.readyToFire));
        this.tickClient.add(TickTimerTileEntity.newConditional(3, tick -> this.spawnBrokenParticles(), () -> this.sharingBoosters));
        this.tickClient.add(TickTimerTileEntity.newConditional(1, tick -> this.spawnLaser(), () -> this.doFireLaser || this.getLaserMode() == LaserModes.FIELD && this.readyToFire && this.shouldFire));
    }

    public boolean canFireLaser() {
        return this.readyToFire && this.shouldFire;
    }

    private void spawnReadyToFireParticles() {
        EnumFacing facing = this.getDirection();
        AtomicScience.sideProxy.spawnParticle(this.getLaserMode().warmedUpParticle, (double)this.func_174877_v().func_177958_n() + 0.5 + 0.5 * (double)facing.func_82601_c(), (double)this.func_174877_v().func_177956_o() + 0.5 + 0.5 * (double)facing.func_96559_d(), (double)this.func_174877_v().func_177952_p() + 0.5 + 0.5 * (double)facing.func_82599_e(), 0.0, 0.0, 0.0);
    }

    private void spawnLaser() {
        double z;
        double y;
        double x;
        this.doFireLaser = this._laserMode != LaserModes.NORMAL;
        EnumFacing facing = this.getDirection();
        double sx = (double)this.func_174877_v().func_177958_n() + 0.5 + 0.5 * (double)facing.func_82601_c();
        double sy = (double)this.func_174877_v().func_177956_o() + 0.5 + 0.5 * (double)facing.func_96559_d();
        double sz = (double)this.func_174877_v().func_177952_p() + 0.5 + 0.5 * (double)facing.func_82599_e();
        BlockPos impactPos = this.getLaserImpactPos();
        if (impactPos != null) {
            x = (double)impactPos.func_177958_n() + 0.5;
            y = (double)impactPos.func_177956_o() + 0.5;
            z = (double)impactPos.func_177952_p() + 0.5;
        } else {
            x = sx + (double)(MAX_RAY_DISTANCE * facing.func_82601_c());
            y = sy + (double)(MAX_RAY_DISTANCE * facing.func_96559_d());
            z = sz + (double)(MAX_RAY_DISTANCE * facing.func_82599_e());
        }
        AtomicScience.sideProxy.spawnParticle(this.getLaserMode().fireParticle, sx, sy, sz, x, y, z);
    }

    private BlockPos getLaserImpactPos() {
        EnumFacing facing = this.getDirection();
        for (int step = 0; step < MAX_RAY_DISTANCE; ++step) {
            BlockPos pos = this.func_174877_v().func_177967_a(facing, step + 1);
            if (this.field_145850_b.func_175667_e(pos)) {
                IBlockState blockState = this.field_145850_b.func_180495_p(pos);
                if (this.canLaserPassThrough(blockState, pos)) continue;
                return pos;
            }
            return pos;
        }
        return null;
    }

    private boolean canLaserPassThrough(IBlockState blockState, BlockPos pos) {
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150359_w || block == Blocks.field_150399_cn || block == Blocks.field_150397_co || block == Blocks.field_150410_aZ || block == Blocks.field_150411_aY) {
            return true;
        }
        return blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.field_145850_b, pos);
    }

    private void spawnBrokenParticles() {
        this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, Math.random() * 0.3, Math.random() * 0.3, Math.random() * 0.3, new int[0]);
    }

    @Override
    protected void sendDescPacket() {
        super.sendDescPacket();
        this.doFireLaser = false;
    }

    @Override
    protected void writeDescPacket(List<Object> dataList, EntityPlayer player) {
        dataList.add(this.readyToFire);
        dataList.add(this.sharingBoosters);
        dataList.add(this.doFireLaser);
        dataList.add((byte)this.getLaserMode().ordinal());
    }

    @Override
    protected void readDescPacket(ByteBuf buf, EntityPlayer player) {
        this.readyToFire = buf.readBoolean();
        this.sharingBoosters = buf.readBoolean();
        this.doFireLaser = buf.readBoolean();
        this._laserMode = LaserModes.get(buf.readByte());
    }

    protected boolean checkForRedstone() {
        this.hasRedstone = this.field_145850_b.func_175640_z(this.func_174877_v());
        return this.hasRedstone;
    }

    protected void checkMachineState() {
        boolean prevReadyToFire = this.readyToFire;
        boolean prevShouldFire = this.shouldFire;
        this.readyToFire = this.battery.getEnergyStored() >= this.getCostToFire() && this.boosterCount > 0;
        boolean bl = this.shouldFire = this.hasRedstone || this.fireOverride;
        if (prevReadyToFire != this.readyToFire || prevShouldFire != this.shouldFire) {
            this.syncClientNextTick();
        }
    }

    public boolean triggerFire() {
        this.fireOverride = true;
        return true;
    }

    public void fire() {
        this.readyToFire = false;
        this.shouldFire = false;
        this.fireOverride = false;
        this.battery.extractEnergy(this.getCostToFire(), false);
        this.doFire();
        this.doFireLaser = true;
        this.cooldown = this.getLaserMode() == LaserModes.FIELD ? 0 : ConfigContent.LASER.LASER_COOLDOWN;
        this.syncClientNextTick();
    }

    protected void doFire() {
        EnumFacing facing = this.getDirection();
        if (this.getLaserMode() == LaserModes.NORMAL) {
            TileEntity tileEntity2;
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing));
            if (tileEntity instanceof TileEntityItemContainer && (tileEntity2 = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(facing, 2))) instanceof TileEntityAcceleratorGun) {
                ((TileEntityAcceleratorGun)tileEntity2).onLaserFiredInto((TileEntityItemContainer)tileEntity, this);
            }
        } else {
            TileEntity tileEntity;
            int steps = 0;
            while ((tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(facing, ++steps))) == null && steps < MAX_RAY_DISTANCE) {
            }
            if (tileEntity instanceof TileEntityItemContainer) {
                int powerToSend = ConfigContent.LASER.FIELD_TRANSFER_POWER * this.boosterCount;
                powerToSend = this.battery.extractEnergy(powerToSend, true);
                int taken = ((TileEntityItemContainer)tileEntity).internalBattery.receiveEnergy(powerToSend, false);
                this.battery.extractEnergy(taken, false);
            }
        }
    }

    public int getCostToFire() {
        return this.getLaserMode().getEnergyCost() * this.boosterCount;
    }

    private void scanForBoosters() {
        EnumFacing boosterFacing;
        TileEntity tileEntity;
        this.boosterCount = 0;
        this.sharingBoosters = false;
        EnumFacing facing = this.getDirection().func_176734_d();
        BlockPos pos = this.func_174877_v();
        for (int i = 0; i < ConfigContent.LASER.BOOSTER_MAX && this.field_145850_b.func_175667_e(pos = pos.func_177972_a(facing)) && (tileEntity = this.field_145850_b.func_175625_s(pos)) instanceof TileEntityLaserBooster && ((boosterFacing = ((TileEntityLaserBooster)tileEntity).getDirection()) == facing || boosterFacing == facing.func_176734_d()); ++i) {
            ++this.boosterCount;
            if (((TileEntityLaserBooster)tileEntity).host != null && ((TileEntityLaserBooster)tileEntity).host != this) {
                this.sharingBoosters = true;
                break;
            }
            ((TileEntityLaserBooster)tileEntity).host = this;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.boosterCount = compound.func_74762_e(NBT_BOOSTER_COUNT);
        this.battery.setEnergy(compound.func_74762_e(NBT_ENERGY));
        this._laserMode = LaserModes.get(compound.func_74762_e(NBT_LASER_MODE));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a(NBT_BOOSTER_COUNT, this.boosterCount);
        compound.func_74768_a(NBT_ENERGY, this.battery.getEnergyStored());
        compound.func_74768_a(NBT_LASER_MODE, this.getLaserMode().ordinal());
        return super.func_189515_b(compound);
    }

    public LaserModes getLaserMode() {
        if (this._laserMode == null) {
            this._laserMode = LaserModes.NORMAL;
        }
        return this._laserMode;
    }

    public void setLaserMode(LaserModes laserMode) {
        this.syncClientNextTick();
        this._laserMode = laserMode;
    }
}

