/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.container.item;

import com.builtbroken.atomic.config.content.ConfigContent;
import com.builtbroken.atomic.content.ASFluids;
import com.builtbroken.atomic.content.machines.container.item.ItemContainerInventory;
import com.builtbroken.atomic.content.prefab.TileEntityMachine;
import com.builtbroken.atomic.lib.power.Battery;
import com.builtbroken.atomic.lib.timer.TickTimerTileEntity;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityItemContainer
extends TileEntityMachine {
    public static final String NBT_INVENTORY = "inventory";
    public static final String NBT_ITEM = "item";
    public static final String NBT_ENERGY = "energy";
    public static final String NBT_FLUID = "fluid";
    private ItemStack _cache;
    public float rotation = 0.0f;
    public final Battery internalBattery = new Battery(() -> ConfigContent.POWER_USAGE.PARTICLE_CAPTURE_COST + ConfigContent.POWER_USAGE.PARTICLE_CONTAINMENT_COST * 10);
    protected final FluidTank internalTank = new FluidTank(100);
    private final ItemContainerInventory inventory = new ItemContainerInventory(this);

    public TileEntityItemContainer() {
        this.tickServer.add(TickTimerTileEntity.newSimple(tick -> this.consumeEnergy()));
        this.tickServer.add(TickTimerTileEntity.newSimple(tick -> this.exportFluid()));
    }

    public void consumeEnergy() {
        FluidStack fluidStack;
        int consumed;
        if (this.hasFluidStored() && (consumed = this.internalBattery.extractEnergy(ConfigContent.POWER_USAGE.PARTICLE_CONTAINMENT_COST, false)) != ConfigContent.POWER_USAGE.PARTICLE_CONTAINMENT_COST && (fluidStack = this.internalTank.drain(Integer.MAX_VALUE, true)) != null) {
            this.field_145850_b.func_72885_a(null, this.x(), this.y(), (double)this.zi(), (float)(fluidStack.amount / 5), true, false);
        }
    }

    public int addAntimatter(int amount, boolean eatItem, boolean explode, boolean consumeEnergy) {
        int consumed;
        if (consumeEnergy && (consumed = this.internalBattery.extractEnergy(ConfigContent.POWER_USAGE.PARTICLE_CONTAINMENT_COST, false)) != ConfigContent.POWER_USAGE.PARTICLE_CONTAINMENT_COST) {
            this.field_145850_b.func_72885_a(null, this.x(), this.y(), (double)this.zi(), (float)(amount / 5), true, false);
            return amount;
        }
        if (!this.getHeldItem().func_190926_b()) {
            if (eatItem) {
                this.setHeldItem(ItemStack.field_190927_a);
            }
            if (explode) {
                this.field_145850_b.func_72885_a(null, this.x(), this.y(), (double)this.zi(), (float)(amount / 5), true, false);
            }
            return amount;
        }
        return this.internalTank.fill(new FluidStack(ASFluids.ANTIMATTER.fluid, amount), true);
    }

    public boolean hasFluidStored() {
        return this.internalTank.getFluid() != null && this.internalTank.getFluidAmount() > 0;
    }

    public void exportFluid() {
        IFluidHandler handler;
        if (this.hasFluidStored() && (handler = (IFluidHandler)this.getCapabilityOnSide(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)) != null) {
            FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this.internalTank, (int)this.internalTank.getFluidAmount(), (boolean)true);
        }
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getHeldItem() {
        if (this.field_145850_b.field_72995_K) {
            return this._cache;
        }
        return this.inventory.getStackInSlot(0);
    }

    public void setHeldItem(ItemStack stack) {
        this.inventory.setStackInSlot(0, stack);
    }

    public int consumeItems() {
        int count = this.getHeldItem().func_190916_E();
        this.inventory.extractItem(0, 64, false);
        return count;
    }

    @Override
    protected void writeDescPacket(List<Object> dataList, EntityPlayer player) {
        dataList.add(this.inventory.getStackInSlot(0));
    }

    @Override
    protected void readDescPacket(ByteBuf buf, EntityPlayer player) {
        this._cache = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_189515_b(tagCompound);
        tagCompound.func_74782_a(NBT_ITEM, (NBTBase)this.getHeldItem().serializeNBT());
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt.func_148857_g().func_74764_b(NBT_ITEM)) {
            this.func_145839_a(pkt.func_148857_g());
            this._cache = new ItemStack(pkt.func_148857_g().func_74775_l(NBT_ITEM));
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l(NBT_INVENTORY));
        this.internalTank.readFromNBT(compound.func_74775_l(NBT_FLUID));
        this.internalBattery.setEnergy(compound.func_74762_e(NBT_ENERGY));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a(NBT_INVENTORY, (NBTBase)this.inventory.serializeNBT());
        compound.func_74782_a(NBT_FLUID, (NBTBase)this.internalTank.writeToNBT(new NBTTagCompound()));
        compound.func_74768_a(NBT_ENERGY, this.internalBattery.getEnergyStored());
        return super.func_189515_b(compound);
    }
}

