/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.accelerator.tube.powered;

import com.builtbroken.atomic.api.accelerator.AcceleratorHelpers;
import com.builtbroken.atomic.config.content.ConfigContent;
import com.builtbroken.atomic.content.machines.accelerator.magnet.TileEntityMagnet;
import com.builtbroken.atomic.content.machines.accelerator.particle.AcceleratorParticle;
import com.builtbroken.atomic.content.machines.accelerator.tube.normal.TileEntityAcceleratorTube;
import com.builtbroken.atomic.content.machines.accelerator.tube.powered.MagnetPos;
import com.builtbroken.atomic.lib.power.Battery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileEntityAcceleratorTubePowered
extends TileEntityAcceleratorTube
implements ITickable {
    public static final float BASE_MAGNET_POWER = 60.0f;
    private int layoutScanTimer = 0;
    protected final List<MagnetPos> magnetPosList = new ArrayList<MagnetPos>();
    protected boolean isLayoutInvalid = false;
    protected float _magnetPower;
    public final Battery battery = new Battery(() -> (int)((double)(ConfigContent.ACCELERATOR.ENERGY_PER_MAGNET * this.magnetPosList.size()) * 1.5));
    float powerScale = 0.0f;

    @Override
    public void onLoad() {
        super.onLoad();
        this.getNode().onMoveCallback = particle -> this.accelerate((AcceleratorParticle)particle);
    }

    public void func_73660_a() {
        if (this.isServer()) {
            this.powerScale = (float)this.battery.extractEnergy(this.getPowerConsumption(), false) / (float)this.getPowerConsumption();
            if (this.layoutScanTimer-- <= 0) {
                this.layoutScanTimer = 100 + this.field_145850_b.field_73012_v.nextInt(100);
                this.updateLayout((IBlockAccess)this.field_145850_b);
            }
        }
    }

    public float getMagnetPower() {
        if (Double.isNaN(this._magnetPower)) {
            return 0.0f;
        }
        return this._magnetPower;
    }

    public int getPowerConsumption() {
        return ConfigContent.ACCELERATOR.ENERGY_PER_MAGNET * this.magnetPosList.size();
    }

    public void accelerate(AcceleratorParticle particle) {
        particle.addEnergy(this.getMagnetPower() * this.powerScale);
        particle.addVelocity(this.getAcceleration() * this.powerScale);
    }

    public float getAcceleration() {
        float baseScale = ConfigContent.ACCELERATOR.ACCELERATION_SCALE * (this.getMagnetPower() / 60.0f);
        return Math.min(ConfigContent.ACCELERATOR.ACCELERATION_MAX, baseScale);
    }

    public void updateLayout(IBlockAccess worldAccess) {
        this.isLayoutInvalid = this.scanForMagnets(worldAccess);
        if (this.isLayoutInvalid) {
            this.magnetPosList.forEach(magnet -> {
                TileEntity tile = worldAccess.func_175625_s(magnet.pos());
                if (tile instanceof TileEntityMagnet) {
                    ((TileEntityMagnet)tile).setOwner(this);
                }
            });
        }
        this._magnetPower = this.calculateMagnetPower();
    }

    public float calculateMagnetPower() {
        float power = 0.0f;
        for (MagnetPos magnetPos : this.magnetPosList) {
            power += magnetPos.power();
        }
        return power;
    }

    public boolean scanForMagnets(IBlockAccess worldAccess) {
        this.magnetPosList.clear();
        this.magnetPosList.forEach(magnet -> {
            TileEntity tile = worldAccess.func_175625_s(magnet.pos());
            if (tile instanceof TileEntityMagnet) {
                ((TileEntityMagnet)tile).setOwner(null);
            }
        });
        HashSet<BlockPos> alreadySearched = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.offer(this.func_174877_v());
        alreadySearched.add(this.func_174877_v());
        ArrayList<EnumFacing> directions = new ArrayList<EnumFacing>(4);
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            if (enumFacing == this.getDirection() || enumFacing == this.getDirection().func_176734_d()) continue;
            directions.add(enumFacing);
        }
        while (queue.peek() != null) {
            BlockPos pos = (BlockPos)queue.poll();
            for (EnumFacing direction : directions) {
                BlockPos next = pos.func_177972_a(direction);
                if (alreadySearched.contains(next)) continue;
                alreadySearched.add(next);
                TileEntity tile = worldAccess.func_175625_s(next);
                float power = AcceleratorHelpers.getMagnetPower(this.tubeCap, tile, direction);
                if (!(power > 0.0f)) continue;
                this.magnetPosList.add(new MagnetPos(next, power));
                queue.offer(next);
            }
        }
        return true;
    }
}

