/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.accelerator.tube.normal;

import com.builtbroken.atomic.content.machines.accelerator.data.TubeConnectionType;
import com.builtbroken.atomic.content.machines.accelerator.data.TubeSide;
import com.builtbroken.atomic.content.machines.accelerator.data.TubeSideType;
import com.builtbroken.atomic.content.machines.accelerator.particle.AcceleratorParticle;
import com.builtbroken.atomic.content.machines.accelerator.tube.imp.TileEntityAcceleratorTubePrefab;
import com.builtbroken.atomic.content.machines.accelerator.tube.normal.BlockAcceleratorTube;
import com.builtbroken.jlib.data.science.units.UnitDisplay;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityAcceleratorTube
extends TileEntityAcceleratorTubePrefab {
    public static final String NBT_ROTATION = "rotation";
    public static final String NBT_CONNECTION = "connection";
    protected EnumFacing _direction;
    private TubeConnectionType _connectionType = TubeConnectionType.NORMAL;
    private static final UnitDisplay.Unit SPEED = new UnitDisplay.Unit("Meters per Tick", "m/t");
    private static final UnitDisplay SPEED_DISPLAY = new UnitDisplay(SPEED, 0.0, false).symbol(true);

    @Override
    public void func_70296_d() {
        super.func_70296_d();
    }

    public void onLoad() {
        this.getNode().onMoveCallback = particle -> this.debugSpeed((AcceleratorParticle)particle);
        if (this.isServer()) {
            this.updateState(false, true);
        }
    }

    public void debugSpeed(AcceleratorParticle particle) {
        float vel = particle.getVelocity();
        TileEntityAcceleratorTube.SPEED_DISPLAY.value = vel;
        TileEntityAcceleratorTube.SPEED_DISPLAY.decimalPlaces = 4;
        String speed = SPEED_DISPLAY.toString();
        this.setSign(this.func_174877_v().func_177972_a(this.getDirection().func_176746_e()), speed);
        this.setSign(this.func_174877_v().func_177972_a(this.getDirection().func_176746_e().func_176734_d()), speed);
    }

    public void setSign(BlockPos pos, String speed) {
        if (this.field_145850_b.func_175667_e(pos)) {
            TileEntity tile = this.getTileEntityIfLoaded(pos);
            IBlockState iblockstate = this.field_145850_b.func_180495_p(pos);
            if (tile instanceof TileEntitySign) {
                String signText1;
                TileEntitySign sign = (TileEntitySign)tile;
                String string = signText1 = sign.field_145915_a[0] != null ? sign.field_145915_a[0].func_150260_c() : null;
                if (signText1 != null && signText1.trim().equalsIgnoreCase("[SPEED]")) {
                    sign.field_145915_a[1] = new TextComponentString(speed);
                    sign.func_70296_d();
                    this.field_145850_b.func_184138_a(pos, iblockstate, iblockstate, 3);
                }
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_ROTATION)) {
            this._direction = EnumFacing.func_82600_a((int)compound.func_74771_c(NBT_ROTATION));
        }
        if (compound.func_74764_b(NBT_CONNECTION)) {
            this.setConnectionType(TubeConnectionType.byIndex(compound.func_74771_c(NBT_CONNECTION)));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.saveStateNBT(compound);
        return super.func_189515_b(compound);
    }

    protected void saveStateNBT(NBTTagCompound compound) {
        compound.func_74774_a(NBT_CONNECTION, (byte)this.getConnectionType().ordinal());
    }

    public IBlockState updateState(boolean doBlockUpdate, boolean setBlock) {
        IBlockState state = this.getState();
        if (this.getDirection() != null) {
            state = state.func_177226_a((IProperty)BlockAcceleratorTube.ROTATION_PROP, (Comparable)this.getDirection());
        }
        state = state.func_177226_a(BlockAcceleratorTube.CONNECTION_PROP, (Comparable)((Object)this.getConnectionType()));
        if (setBlock && this.field_145850_b != null) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), state, doBlockUpdate ? 3 : 2);
            if (this.isServer()) {
                this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
                this.sendDescPacket();
            }
        }
        return state;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.saveStateNBT(tag);
        return tag;
    }

    public boolean func_145842_c(int id, int type) {
        return false;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @Override
    protected void writeDescPacket(List<Object> dataList, EntityPlayer player) {
        dataList.add((byte)this.getConnectionType().ordinal());
    }

    @Override
    protected void readDescPacket(ByteBuf buf, EntityPlayer player) {
        this.setConnectionType(TubeConnectionType.byIndex(buf.readByte()));
    }

    public IBlockState updateConnections(IBlockAccess access, boolean updateBlockState, boolean updateState) {
        TubeConnectionType type = this.calcConnectionType(access);
        if (type != TubeConnectionType.INVALID) {
            this.setConnectionType(type);
        } else {
            type = this.guessConnectionType(access);
            if (type != TubeConnectionType.INVALID) {
                this.setConnectionType(type);
            }
        }
        if (this.getNode().updateConnections(access) && this.getNode().getNetwork() != null) {
            this.getNode().getNetwork().destroy();
        }
        return updateState ? this.updateState(false, updateBlockState) : null;
    }

    public TubeConnectionType calcConnectionType(IBlockAccess access) {
        TubeSideType front = this.getNode().getConnectedTubeState(access, TubeSide.FRONT);
        TubeSideType left = this.getNode().getConnectedTubeState(access, TubeSide.LEFT);
        TubeSideType right = this.getNode().getConnectedTubeState(access, TubeSide.RIGHT);
        TubeSideType back = this.getNode().getConnectedTubeState(access, TubeSide.BACK);
        return TubeConnectionType.getTypeForLayout(front, left, right, back, true);
    }

    public TubeConnectionType guessConnectionType(IBlockAccess access) {
        TubeSideType left = this.getNode().getConnectedTubeState(access, TubeSide.LEFT);
        TubeSideType right = this.getNode().getConnectedTubeState(access, TubeSide.RIGHT);
        TubeSideType back = this.getNode().getConnectedTubeState(access, TubeSide.BACK);
        return TubeConnectionType.getTypeForLayout(TubeSideType.EXIT, left, right, back, true);
    }

    @Override
    public EnumFacing getDirection() {
        if (this._direction == null) {
            this._direction = super.getDirection();
        }
        return this._direction;
    }

    @Override
    public void setDirection(EnumFacing facing) {
        super.setDirection(facing);
        this._direction = null;
    }

    @Override
    public TubeConnectionType getConnectionType() {
        if (this._connectionType == null) {
            this._connectionType = TubeConnectionType.NORMAL;
        }
        return this._connectionType;
    }

    public void setConnectionType(TubeConnectionType type) {
        TubeConnectionType prev = this.getConnectionType();
        if (prev != type) {
            this._connectionType = type;
        }
    }
}

