/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.accelerator.tube.normal;

import com.builtbroken.atomic.content.ASBlocks;
import com.builtbroken.atomic.content.ASItems;
import com.builtbroken.atomic.content.machines.accelerator.data.TubeConnectionType;
import com.builtbroken.atomic.content.machines.accelerator.data.TubeSide;
import com.builtbroken.atomic.content.machines.accelerator.tube.normal.TileEntityAcceleratorTube;
import com.builtbroken.atomic.content.prefab.BlockMachine;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAcceleratorTube
extends BlockMachine {
    public static final PropertyEnum<TubeConnectionType> CONNECTION_PROP = PropertyEnum.func_177707_a((String)"connection", TubeConnectionType.class, Arrays.asList(TubeConnectionType.values()));

    public BlockAcceleratorTube(Material material) {
        super(material);
    }

    public BlockAcceleratorTube() {
        this(Material.field_151573_f);
        this.setRegistryName("atomicscience:accelerator_tube");
        this.func_149663_c("atomicscience:accelerator.tube");
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing placement = BlockAcceleratorTube.getPlacement(facing, hitX, hitY, hitZ);
        if (placer.func_70093_af()) {
            placement = placement.func_176734_d();
        }
        if (placement.func_176740_k() == EnumFacing.Axis.Y) {
            placement = placer.func_174811_aO();
        }
        return this.func_176223_P().func_177226_a((IProperty)ROTATION_PROP, (Comparable)placement);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAcceleratorTube) {
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (heldItem.func_77973_b() == Items.field_151055_y) {
                if (!world.field_72995_K) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("Block Debug:"));
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("---Pos: " + pos));
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("---Dir: " + ((TileEntityAcceleratorTube)tile).getDirection() + "==" + state.func_177229_b((IProperty)ROTATION_PROP)));
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("---Connection: " + state.func_177229_b(CONNECTION_PROP)));
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("---Network: " + ((TileEntityAcceleratorTube)tile).getNode().getNetwork().uuid));
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("---Particles: " + ((TileEntityAcceleratorTube)tile).getNode().getParticles().size()));
                }
                return true;
            }
            if (heldItem.func_77973_b() == Items.field_151072_bj) {
                if (!world.field_72995_K) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("Connection State:"));
                    for (TubeSide side : TubeSide.SIDES) {
                        playerIn.func_145747_a((ITextComponent)new TextComponentString("---" + side.name() + ": " + (Object)((Object)((TileEntityAcceleratorTube)tile).getNode().getConnectedTubeState(null, side))));
                    }
                }
                return true;
            }
            if (heldItem.func_77973_b() == Items.field_151137_ax) {
                if (((TileEntityAcceleratorTube)tile).getConnectionType() == TubeConnectionType.NORMAL) {
                    this.switchType(world, pos, state, tile);
                } else if (!world.field_72995_K) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_149739_a() + ".error.normal.conversion", new Object[0]), true);
                }
                return true;
            }
            if (heldItem.func_77973_b() == ASItems.itemWrench) {
                if (playerIn.func_70093_af()) {
                    // empty if block
                }
                return true;
            }
        }
        return false;
    }

    protected void switchType(World world, BlockPos pos, IBlockState currentState, TileEntity tile) {
        NBTTagCompound save = new NBTTagCompound();
        tile.func_189515_b(save);
        save.func_82580_o("id");
        tile.func_145843_s();
        world.func_175656_a(pos, this.getSwitchState(currentState));
        currentState = world.func_180495_p(pos);
        tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAcceleratorTube) {
            tile.func_145839_a(save);
            ((TileEntityAcceleratorTube)tile).updateConnections((IBlockAccess)world, false, true);
            ((TileEntityAcceleratorTube)tile).updateState(true, true);
            if (((TileEntityAcceleratorTube)tile).getNode().getNetwork() != null) {
                ((TileEntityAcceleratorTube)tile).getNode().getNetwork().destroy();
            }
            tile.func_70296_d();
            world.func_184138_a(pos, currentState, world.func_180495_p(pos), 3);
        }
    }

    protected IBlockState getSwitchState(IBlockState currentState) {
        IBlockState newState = ASBlocks.blockAcceleratorTubePowered.func_176223_P();
        newState = newState.func_177226_a(CONNECTION_PROP, currentState.func_177229_b(CONNECTION_PROP));
        newState = newState.func_177226_a((IProperty)ROTATION_PROP, currentState.func_177229_b((IProperty)ROTATION_PROP));
        return newState;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION_PROP, CONNECTION_PROP});
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAcceleratorTube) {
            ((TileEntityAcceleratorTube)tile).updateConnections((IBlockAccess)world, true, true);
            ((TileEntityAcceleratorTube)tile).getNode().updateConnections((IBlockAccess)world);
        }
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176206_d(worldIn, pos, state);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAcceleratorTube && ((TileEntityAcceleratorTube)tile).getNode().getNetwork() != null) {
            ((TileEntityAcceleratorTube)tile).getNode().getNetwork().destroy();
        }
        super.func_180663_b(world, pos, state);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAcceleratorTube) {
            return state.func_177226_a(CONNECTION_PROP, (Comparable)((Object)((TileEntityAcceleratorTube)tile).getConnectionType()));
        }
        return state;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tile;
        IBlockState state = world.func_180495_p(neighbor);
        if ((state.func_177230_c() == ASBlocks.blockAcceleratorTube || state.func_177230_c() == ASBlocks.blockAcceleratorTubePowered || state.func_177230_c() == ASBlocks.blockAcceleratorExit || state.func_177230_c() == ASBlocks.blockAcceleratorGun) && (tile = world.func_175625_s(pos)) instanceof TileEntityAcceleratorTube && tile.func_145831_w() != null && !((TileEntityAcceleratorTube)tile).world().field_72995_K && ((TileEntityAcceleratorTube)tile).getNode().updateConnections(world) && ((TileEntityAcceleratorTube)tile).getNode().getNetwork() != null) {
            ((TileEntityAcceleratorTube)tile).getNode().getNetwork().destroy();
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityAcceleratorTube();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

