/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.accelerator.particle;

import com.builtbroken.atomic.api.accelerator.IAcceleratorNode;
import com.builtbroken.atomic.api.accelerator.IAcceleratorParticle;
import com.builtbroken.atomic.config.content.ConfigContent;
import com.builtbroken.atomic.content.machines.accelerator.graph.AcceleratorNode;
import com.builtbroken.atomic.lib.transform.move.FractionPos;
import com.builtbroken.atomic.lib.transform.move.IMovablePos;
import com.builtbroken.atomic.lib.transform.move.MovableFPos;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class AcceleratorParticle
implements IAcceleratorParticle {
    public static final String NBT_ID = "id";
    public static final String NBT_DIM = "dim";
    public static final String NBT_VELOCITY = "velocity";
    public static final String NBT_ENERGY = "energy";
    public static final String NBT_X = "x";
    public static final String NBT_Y = "y";
    public static final String NBT_Z = "z";
    public static final String NBT_DIR = "direction";
    public static final String NBT_STACK = "item";
    public static final String NBT_IN_TUBE = "in_tube";
    public static final String NBT_ALIVE = "alive";
    public final UUID unique_id;
    private float velocity;
    private float energy;
    private int dim;
    private IMovablePos pos;
    private EnumFacing moveDirection;
    private IAcceleratorNode node;
    private ItemStack itemStack = ItemStack.field_190927_a;
    private boolean notInTube = false;
    private boolean isAlive = true;

    public AcceleratorParticle(NBTTagCompound nbt) {
        this.unique_id = nbt.func_74764_b(NBT_ID) ? NBTUtil.func_186860_b((NBTTagCompound)nbt.func_74775_l(NBT_ID)) : UUID.randomUUID();
        this.load(nbt);
    }

    public AcceleratorParticle(int dim, BlockPos start, EnumFacing moveDirection, float energy) {
        this.unique_id = UUID.randomUUID();
        this.dim = dim;
        this.pos().set(start);
        this.moveDirection = moveDirection;
        this.energy = energy;
        this.velocity = 0.1f;
    }

    protected IMovablePos pos() {
        if (this.pos == null) {
            this.pos = ConfigContent.ACCELERATOR.FRACTION_MATH ? new FractionPos() : new MovableFPos();
        }
        return this.pos;
    }

    public void update(int worldTick) {
        this.move();
        this.consumeEnergy();
    }

    protected void move() {
        if (Double.isNaN(this.velocity) || this.velocity <= 0.0f) {
            this.velocity = 0.1f;
        }
        float distanceToMove = Math.max(this.velocity, 0.1f);
        IAcceleratorNode currentNode = this.getCurrentNode();
        if (currentNode != null) {
            while (distanceToMove > 0.001f && currentNode != null) {
                EnumFacing prevDirection = this.moveDirection;
                float distanceMoved = currentNode.move(this, distanceToMove);
                distanceToMove -= distanceMoved;
                if (!((double)Math.abs(distanceMoved) <= 1.0E-4)) {
                    if (prevDirection != this.moveDirection) {
                        this.consumeEnergy();
                    }
                    currentNode = this.getCurrentNode();
                    continue;
                }
                break;
            }
        } else {
            this.notInTube = true;
        }
    }

    public void move(float x, float y, float z) {
        this.pos().move(x, y, z);
    }

    public void move(float moveAmount, EnumFacing direction) {
        this.move(moveAmount * (float)direction.func_82601_c(), moveAmount * (float)direction.func_96559_d(), moveAmount * (float)direction.func_82599_e());
    }

    protected void consumeEnergy() {
        this.energy -= 1.0f;
    }

    public void addEnergy(float magnetPower) {
        this.energy += magnetPower;
    }

    public void setMoveDirection(EnumFacing direction) {
        this.moveDirection = direction;
    }

    public void setVelocity(float v) {
        this.velocity = v;
    }

    public void addVelocity(float acceleration) {
        this.setVelocity(this.velocity + acceleration);
    }

    public float getVelocity() {
        return this.velocity;
    }

    @Override
    public int dim() {
        return this.dim;
    }

    @Override
    public double z() {
        return this.pos().z();
    }

    @Override
    public double x() {
        return this.pos().x();
    }

    @Override
    public double y() {
        return this.pos().y();
    }

    @Override
    public float zf() {
        return this.pos().zf();
    }

    @Override
    public float xf() {
        return this.pos().xf();
    }

    @Override
    public float yf() {
        return this.pos().yf();
    }

    public void setPos(float x, float y, float z) {
        this.pos().set(x, y, z);
    }

    public IAcceleratorNode getCurrentNode() {
        return this.node;
    }

    public AcceleratorParticle setCurrentNode(AcceleratorNode node) {
        this.node = node;
        return this;
    }

    public ItemStack getItem() {
        return this.itemStack;
    }

    public AcceleratorParticle setItem(ItemStack stack) {
        this.itemStack = stack;
        if (stack == null) {
            this.itemStack = ItemStack.field_190927_a;
        }
        return this;
    }

    public EnumFacing getMoveDirection() {
        if (this.moveDirection == null) {
            this.moveDirection = EnumFacing.NORTH;
        }
        return this.moveDirection;
    }

    @Override
    public boolean isDead() {
        return this.notInTube || !this.isAlive;
    }

    public void setDead() {
        this.isAlive = false;
    }

    public String toString() {
        return String.format("AcceleratorParticle[Pos: %.2f, %.2f, %.2f", this.x(), this.y(), this.z()) + " Dir:" + this.moveDirection + "]@" + this.hashCode();
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        nbt.func_74782_a(NBT_ID, (NBTBase)NBTUtil.func_186862_a((UUID)this.unique_id));
        nbt.func_74776_a(NBT_VELOCITY, this.velocity);
        nbt.func_74776_a(NBT_ENERGY, this.energy);
        nbt.func_74768_a(NBT_DIM, this.dim);
        nbt.func_74776_a(NBT_X, this.xf());
        nbt.func_74776_a(NBT_Y, this.yf());
        nbt.func_74776_a(NBT_Z, this.zf());
        nbt.func_74774_a(NBT_DIR, (byte)this.getMoveDirection().ordinal());
        nbt.func_74782_a(NBT_STACK, (NBTBase)this.itemStack.serializeNBT());
        nbt.func_74757_a(NBT_IN_TUBE, this.notInTube);
        nbt.func_74757_a(NBT_ALIVE, this.isAlive);
        return nbt;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.velocity = nbt.func_74760_g(NBT_VELOCITY);
        this.energy = nbt.func_74760_g(NBT_ENERGY);
        this.dim = nbt.func_74762_e(NBT_DIM);
        this.setPos(nbt.func_74760_g(NBT_X), nbt.func_74760_g(NBT_Y), nbt.func_74760_g(NBT_Z));
        this.moveDirection = EnumFacing.func_82600_a((int)nbt.func_74771_c(NBT_DIR));
        this.itemStack = new ItemStack(nbt.func_74775_l(NBT_STACK));
        this.notInTube = nbt.func_74767_n(NBT_IN_TUBE);
        this.isAlive = nbt.func_74767_n(NBT_ALIVE);
    }
}

