/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.accelerator.gun;

import com.builtbroken.atomic.api.AtomicScienceAPI;
import com.builtbroken.atomic.api.accelerator.AcceleratorHelpers;
import com.builtbroken.atomic.api.accelerator.IAcceleratorTube;
import com.builtbroken.atomic.content.machines.accelerator.data.TubeConnectionType;
import com.builtbroken.atomic.content.machines.accelerator.graph.AcceleratorHandler;
import com.builtbroken.atomic.content.machines.accelerator.graph.AcceleratorNetwork;
import com.builtbroken.atomic.content.machines.accelerator.tube.imp.AcceleratorTubeCap;
import com.builtbroken.atomic.content.machines.container.item.TileEntityItemContainer;
import com.builtbroken.atomic.content.machines.laser.emitter.TileEntityLaserEmitter;
import com.builtbroken.atomic.content.prefab.TileEntityMachine;
import com.builtbroken.atomic.lib.timer.TickTimerTileEntity;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityAcceleratorGun
extends TileEntityMachine {
    public static final String NBT_NODE = "accelerator_node";
    public final AcceleratorTubeCap tubeCap = new AcceleratorTubeCap(this, () -> this.getDirection(), () -> TubeConnectionType.START_CAP);
    private boolean hasValidatedThisTick = true;

    public TileEntityAcceleratorGun() {
        this.tickServer.add(TickTimerTileEntity.newConditional(20, tick -> this.validateNetwork(), () -> this.tubeCap.getNode().getNetwork() == null || this.tubeCap.getNode().getNetwork().isDead()));
        this.tickServer.add(TickTimerTileEntity.newSimple(tick -> {
            this.hasValidatedThisTick = false;
        }));
    }

    public void onLoad() {
        this.tubeCap.getNode().onNetworkDestroyed = node -> this.validateNetwork();
    }

    private void validateNetwork() {
        if (!this.hasValidatedThisTick) {
            this.hasValidatedThisTick = true;
            if (this.tubeCap.getNode().getNetwork() == null) {
                EnumFacing facing = this.getDirection();
                TileEntity tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing));
                IAcceleratorTube tube = AcceleratorHelpers.getAcceleratorTube(tileEntity, null);
                if (tube != null) {
                    tube.getNode().connect(this.tubeCap.getNode(), this.getDirection().func_176734_d());
                }
            }
            if (this.tubeCap.getNode().getNetwork() != null) {
                this.tubeCap.getNode().getNetwork().init((IBlockAccess)this.func_145831_w(), this.func_174877_v().func_177972_a(this.getDirection()));
            }
        }
    }

    private void createNewNetwork() {
        this.tubeCap.getNode().setNetwork(new AcceleratorNetwork(this.dim()));
    }

    public void onLaserFiredInto(TileEntityItemContainer container, TileEntityLaserEmitter laserEmitter) {
        ItemStack heldItem;
        if (laserEmitter.getDirection() == this.getDirection() && !(heldItem = container.getHeldItem()).func_190926_b()) {
            this.createParticle(heldItem, laserEmitter.boosterCount / container.consumeItems());
        }
    }

    public void createParticle(ItemStack item, int energyToStart) {
        AcceleratorHandler.newParticle(this.field_145850_b, this.tubeCap.getNode(), item, energyToStart);
    }

    public boolean fireLaser() {
        TileEntityLaserEmitter laser = this.getLaser();
        if (laser != null) {
            return laser.triggerFire();
        }
        return false;
    }

    public TileEntityLaserEmitter getLaser() {
        TileEntityLaserEmitter laser;
        EnumFacing facing = this.getDirection().func_176734_d();
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(facing, 2));
        if (tileEntity instanceof TileEntityLaserEmitter && (laser = (TileEntityLaserEmitter)tileEntity).getDirection() == this.getDirection()) {
            return laser;
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == AtomicScienceAPI.ACCELERATOR_TUBE_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == AtomicScienceAPI.ACCELERATOR_TUBE_CAPABILITY) {
            return (T)this.tubeCap;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tubeCap.getNode().load(compound.func_74775_l(NBT_NODE));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a(NBT_NODE, (NBTBase)this.tubeCap.getNode().save(new NBTTagCompound()));
        return super.func_189515_b(compound);
    }
}

