/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.accelerator.graph;

import com.builtbroken.atomic.content.machines.accelerator.graph.AcceleratorNetwork;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.world.World;

public class AcceleratorWorld {
    public final int dim;
    public final HashMap<UUID, AcceleratorNetwork> networks = new HashMap();
    private final Queue<AcceleratorNetwork> addList = new LinkedList<AcceleratorNetwork>();
    private int _tick = 0;

    public AcceleratorWorld(int dimension) {
        this.dim = dimension;
    }

    public void save() {
    }

    public void load() {
    }

    public void update(World world) {
        while (this.addList.peek() != null) {
            AcceleratorNetwork network2 = this.addList.poll();
            if (network2.isDead() || this.networks.containsKey(network2.uuid)) continue;
            this.networks.put(network2.uuid, network2);
        }
        this.networks.values().stream().filter(network -> network.isDead()).collect(Collectors.toList()).forEach(this::doRemove);
        this.networks.values().forEach(network -> network.update(world, this._tick));
    }

    private void doRemove(AcceleratorNetwork network) {
        network.onNetworkRemoved();
        this.networks.remove(network.uuid);
    }

    public void unload(World world) {
        this.networks.clear();
    }

    public void add(AcceleratorNetwork acceleratorNetwork) {
        this.addList.offer(acceleratorNetwork);
    }
}

