/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.accelerator.graph;

import com.builtbroken.atomic.api.accelerator.AcceleratorHelpers;
import com.builtbroken.atomic.api.accelerator.IAcceleratorNode;
import com.builtbroken.atomic.api.accelerator.IAcceleratorTube;
import com.builtbroken.atomic.content.machines.accelerator.data.TubeConnectionType;
import com.builtbroken.atomic.content.machines.accelerator.data.TubeSide;
import com.builtbroken.atomic.content.machines.accelerator.data.TubeSideType;
import com.builtbroken.atomic.content.machines.accelerator.graph.AcceleratorComponent;
import com.builtbroken.atomic.content.machines.accelerator.graph.AcceleratorHandler;
import com.builtbroken.atomic.content.machines.accelerator.graph.AcceleratorNetwork;
import com.builtbroken.atomic.content.machines.accelerator.particle.AcceleratorParticle;
import com.builtbroken.atomic.lib.math.BlockPosHelpers;
import com.builtbroken.atomic.lib.math.SideMathHelper;
import com.builtbroken.atomic.network.IPacket;
import com.builtbroken.atomic.network.netty.PacketSystem;
import com.builtbroken.atomic.network.packet.client.PacketAcceleratorParticleSync;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class AcceleratorNode
extends AcceleratorComponent
implements IAcceleratorNode {
    public static final String NBT_TURN_INDEX = "turn_index";
    public static final String NBT_PARTICLES = "particles";
    private final IAcceleratorNode[] nodes = new IAcceleratorNode[6];
    private AcceleratorNetwork network;
    private List<AcceleratorParticle> currentParticles = new ArrayList<AcceleratorParticle>(3);
    private final Queue<AcceleratorParticle> newParticles = new LinkedList<AcceleratorParticle>();
    public int turnIndex = 0;
    public Consumer<AcceleratorParticle> onExitCallback;
    public Consumer<AcceleratorParticle> onLeaveCallback;
    public Consumer<AcceleratorParticle> onEnterCallback;
    public Consumer<AcceleratorParticle> onMoveCallback;
    public Consumer<AcceleratorNode> onNetworkDestroyed;
    public BiFunction<AcceleratorParticle, ImmutableList<TubeSide>, TubeSide> turnController;
    public IAcceleratorTube host;

    public AcceleratorNode(IAcceleratorTube tube) {
        super(() -> tube.dim(), () -> tube.getPosition());
        this.host = tube;
        this.onLeaveCallback = particle -> AcceleratorHandler.spawnParticleInWorld(particle);
    }

    @Override
    public void setNetwork(AcceleratorNetwork network) {
        this.network = network;
    }

    @Override
    public AcceleratorNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void onNetworkRemoved() {
        if (this.onNetworkDestroyed != null) {
            this.onNetworkDestroyed.accept(this);
        }
    }

    @Override
    public List<AcceleratorParticle> getParticles() {
        return this.currentParticles;
    }

    @Deprecated
    public void add(AcceleratorParticle particle) {
        this.newParticles.add(particle);
    }

    @Override
    public void update(World world, int tick) {
        if (this.newParticles.peek() != null) {
            this.host.markDirty();
            do {
                AcceleratorParticle particle = this.newParticles.poll();
                particle.setCurrentNode(this);
                this.currentParticles.add(particle);
            } while (this.newParticles.peek() != null);
        }
        if (this.currentParticles.size() > 0) {
            this.host.markDirty();
            Iterator<AcceleratorParticle> iterator = this.currentParticles.iterator();
            while (iterator.hasNext()) {
                AcceleratorParticle particle = iterator.next();
                if (particle.isDead() || particle.getCurrentNode() != this) {
                    iterator.remove();
                    continue;
                }
                particle.update(tick);
            }
            this.currentParticles.forEach(acceleratorParticle -> {
                PacketAcceleratorParticleSync packet = new PacketAcceleratorParticleSync((AcceleratorParticle)acceleratorParticle);
                PacketSystem.INSTANCE.sendToAllAround((IPacket)packet, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), acceleratorParticle.x(), acceleratorParticle.y(), acceleratorParticle.z(), 30.0));
            });
        }
    }

    @Override
    public boolean updateConnections(IBlockAccess world) {
        IAcceleratorNode node;
        boolean connectionStateChanged = false;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            node = this.getNode(world, facing);
            if (node == null && this.getNode(facing) != null) {
                connectionStateChanged = true;
                continue;
            }
            if (node == null) continue;
            if (this.getNode(facing) == null) {
                connectionStateChanged = true;
            }
            this.nodes[facing.ordinal()] = node;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            node = this.getNode(facing);
            if (node == null || node.isDead()) continue;
            if (this.canConnectToTubeOnSide(TubeSide.getSideFacingOut(this.getDirection(), facing))) {
                this.connect(node, facing);
                continue;
            }
            this.nodes[facing.ordinal()] = null;
        }
        return connectionStateChanged;
    }

    @Override
    public void connect(IAcceleratorNode acceleratorNode, EnumFacing facing) {
        if (acceleratorNode != null && facing != null) {
            int index = facing.ordinal();
            int indexInv = facing.func_176734_d().ordinal();
            if (this.getNodes()[index] != acceleratorNode) {
                this.getNodes()[index] = acceleratorNode;
            }
            if (acceleratorNode.getNodes()[indexInv] != this) {
                acceleratorNode.getNodes()[indexInv] = this;
            }
            if (acceleratorNode.getNetwork() == null) {
                if (this.getNetwork() == null) {
                    this.setNetwork(new AcceleratorNetwork(this.dim()));
                    this.getNetwork().connect(this);
                    this.getNetwork().connect(acceleratorNode);
                    this.getNetwork().registerNetwork();
                } else {
                    this.getNetwork().connect(acceleratorNode);
                }
            } else if (this.getNetwork() == null) {
                acceleratorNode.getNetwork().connect(this);
            }
        }
    }

    public TubeSideType getConnectedTubeState(IBlockAccess access, TubeSide localSide) {
        IAcceleratorNode tube;
        EnumFacing facingSide = localSide.getFacing(this.getDirection());
        IAcceleratorNode iAcceleratorNode = tube = access == null ? this.getNode(facingSide) : this.getNode(access, facingSide);
        if (tube != null) {
            return tube.getConnectionState(facingSide.func_176734_d()).getOpposite();
        }
        return TubeSideType.NONE;
    }

    public IAcceleratorNode getNode(IBlockAccess access, EnumFacing facing) {
        TileEntity tileEntity = access.func_175625_s(this.getPos().func_177972_a(facing));
        IAcceleratorTube tube = AcceleratorHelpers.getAcceleratorTube(tileEntity, facing.func_176734_d());
        if (tube != null && !tube.isDead()) {
            return tube.getNode();
        }
        return null;
    }

    protected IAcceleratorNode getNode(EnumFacing side) {
        return this.nodes[side.ordinal()];
    }

    public boolean canConnectToTubeOnSide(TubeSide localSide) {
        TubeSideType state = this.getConnectedTubeState(null, localSide);
        return state != TubeSideType.NONE && this.getConnectionType().getTypeForSide(localSide) == state;
    }

    @Override
    public float move(AcceleratorParticle particle, float distanceToMove) {
        float deltaX = BlockPosHelpers.getCenterDeltaX(this.getPos(), particle);
        float deltaZ = BlockPosHelpers.getCenterDeltaZ(this.getPos(), particle);
        EnumFacing moveDir = particle.getMoveDirection();
        EnumFacing containingDir = SideMathHelper.containingSide(deltaX, 0.0f, deltaZ);
        TubeSide containingSide = this.getSideFacingOut(containingDir);
        if (!this.isValidSideForParticle(containingSide)) {
            this.moveToNextNode(particle, null);
            return 0.0f;
        }
        if (containingSide == TubeSide.CENTER) {
            BlockPosHelpers.center(this.getPos(), (x, y, z) -> particle.setPos(x, y, z));
            this.doTurn(particle);
            return this.moveForward(particle, deltaX, deltaZ, distanceToMove);
        }
        if (this.getConnectionType().getTypeForSide(containingSide) == TubeSideType.EXIT) {
            return this.moveForward(particle, deltaX, deltaZ, distanceToMove);
        }
        if (this.getConnectionType().getTypeForSide(containingSide) == TubeSideType.ENTER) {
            return this.moveToCenter(particle, deltaX, deltaZ, distanceToMove);
        }
        System.out.println(this + " - Invalid particle direction combo: " + particle);
        particle.setCurrentNode(null);
        return 0.0f;
    }

    public void doTurn(AcceleratorParticle particle) {
        particle.setMoveDirection(this.getExpectedTurnResult(particle));
        this.incrementTurnIndex();
    }

    public EnumFacing getExpectedTurnResult(AcceleratorParticle particle) {
        if (this.getPossibleExitCount() > 1) {
            TubeSide side;
            if (this.turnController != null && (side = this.turnController.apply(particle, this.getConnectionType().outputSides)) != null) {
                return side.getFacing(this.host.getDirection());
            }
            side = (TubeSide)((Object)this.getConnectionType().outputSides.get(this.turnIndex));
            return side.getFacing(this.host.getDirection());
        }
        return this.host.getDirection();
    }

    private int incrementTurnIndex() {
        ++this.turnIndex;
        if (this.turnIndex >= this.getPossibleExitCount() || this.turnIndex < 0) {
            this.turnIndex = 0;
        }
        return this.turnIndex;
    }

    private int getPossibleExitCount() {
        return this.getConnectionType().outputSides.size();
    }

    private boolean isValidSideForParticle(TubeSide side) {
        return side == null || side == TubeSide.CENTER || this.getConnectionType().getTypeForSide(side) != TubeSideType.NONE;
    }

    private TubeSide getSideFacingOut(EnumFacing side) {
        return TubeSide.getSideFacingOut(this.host.getDirection(), side);
    }

    private float moveToCenter(AcceleratorParticle particle, float deltaX, float deltaZ, float distanceToMove) {
        float remaining = SideMathHelper.remainingDistanceCenter(deltaX, deltaZ, particle.getMoveDirection());
        return this.move(particle, particle.getMoveDirection(), remaining, distanceToMove);
    }

    private float moveForward(AcceleratorParticle particle, float deltaX, float deltaZ, float distanceToMove) {
        float remaining = SideMathHelper.remainingDistanceToSide(deltaX, deltaZ, particle.getMoveDirection());
        return this.move(particle, particle.getMoveDirection(), remaining, distanceToMove);
    }

    private float move(AcceleratorParticle particle, EnumFacing direction, float remaining, float distanceToMove) {
        float moveAmount;
        if (this.onMoveCallback != null) {
            this.onMoveCallback.accept(particle);
        }
        if ((moveAmount = Math.min(remaining, distanceToMove)) <= 0.001f) {
            this.moveToNextNode(particle, this.getNodes()[direction.ordinal()]);
        } else {
            particle.move(moveAmount, direction);
        }
        return moveAmount;
    }

    protected void moveToNextNode(AcceleratorParticle particle, IAcceleratorNode node) {
        this.onParticleExit(particle);
        if (node != null) {
            node.onParticleEnter(particle);
        } else if (this.onLeaveCallback != null) {
            this.onLeaveCallback.accept(particle);
        }
    }

    @Override
    public IAcceleratorNode[] getNodes() {
        return this.nodes;
    }

    @Override
    public void onParticleEnter(AcceleratorParticle particle) {
        this.addParticle(particle);
        if (this.onEnterCallback != null) {
            this.onEnterCallback.accept(particle);
        }
    }

    public void addParticle(AcceleratorParticle particle) {
        if (particle != null) {
            this.newParticles.offer(particle);
        }
    }

    @Override
    public void onParticleExit(AcceleratorParticle particle) {
        particle.setCurrentNode(null);
        if (this.onExitCallback != null) {
            this.onExitCallback.accept(particle);
        }
    }

    @Override
    public EnumFacing getDirection() {
        return this.host.getDirection();
    }

    @Override
    public TubeConnectionType getConnectionType() {
        return this.host.getConnectionType();
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        nbt.func_74768_a(NBT_TURN_INDEX, this.turnIndex);
        if (!this.currentParticles.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (AcceleratorParticle particle : this.currentParticles) {
                if (particle.isDead()) continue;
                NBTTagCompound save = new NBTTagCompound();
                particle.save(save);
                list.func_74742_a((NBTBase)save);
            }
            nbt.func_74782_a(NBT_PARTICLES, (NBTBase)list);
        }
        return nbt;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.turnIndex = nbt.func_74762_e(NBT_TURN_INDEX);
        if (nbt.func_74764_b(NBT_PARTICLES)) {
            this.currentParticles.clear();
            NBTTagList list = nbt.func_150295_c(NBT_PARTICLES, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound save = list.func_150305_b(i);
                this.addParticle(new AcceleratorParticle(save));
            }
        }
    }

    @Override
    public boolean isDead() {
        return this.host == null || this.host.isDead();
    }

    public int hashCode() {
        return this.getPos().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IAcceleratorNode) {
            return this.getPos().equals((Object)((IAcceleratorNode)object).getPos());
        }
        return false;
    }

    public String toString() {
        return "AcceleratorNode[" + this.getPos() + ", " + this.getDirection() + ", " + (Object)((Object)this.getConnectionType()) + "]";
    }
}

