/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.accelerator.graph;

import com.builtbroken.atomic.api.accelerator.AcceleratorHelpers;
import com.builtbroken.atomic.api.accelerator.IAcceleratorNode;
import com.builtbroken.atomic.api.accelerator.IAcceleratorTube;
import com.builtbroken.atomic.content.machines.accelerator.graph.AcceleratorHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class AcceleratorNetwork {
    public final UUID uuid;
    public final int dim;
    private boolean destroyNetwork = false;
    private boolean init = false;
    private final Set<IAcceleratorNode> nodes = new HashSet<IAcceleratorNode>();

    public AcceleratorNetwork(int dim) {
        this(dim, UUID.randomUUID());
    }

    public AcceleratorNetwork(int dim, UUID uuid) {
        this.dim = dim;
        this.uuid = uuid;
    }

    public AcceleratorNetwork registerNetwork() {
        AcceleratorHandler.getOrCreate(this.dim).add(this);
        return this;
    }

    public void init(IBlockAccess world, BlockPos start) {
        if (!this.init) {
            this.init = true;
            this.path(world, start);
        }
    }

    public void update(World world, int tick) {
        if (this.getNodes().removeIf(node -> node.isDead())) {
            this.destroy();
        } else {
            this.getNodes().forEach(node -> node.update(world, tick));
        }
    }

    public void connect(IAcceleratorNode acceleratorNode) {
        this.nodes.add(acceleratorNode);
        acceleratorNode.setNetwork(this);
    }

    public void clear() {
        this.getNodes().clear();
    }

    public void destroy() {
        if (this.init) {
            this.destroyNetwork = true;
        }
    }

    public void onNetworkRemoved() {
        this.getNodes().forEach(node -> node.setNetwork(null));
        this.getNodes().forEach(node -> node.onNetworkRemoved());
        this.clear();
    }

    public void path(IBlockAccess world, BlockPos start) {
        HashSet<BlockPos> pathedPositions = new HashSet<BlockPos>();
        Stack<BlockPos> positionsToPath = new Stack<BlockPos>();
        positionsToPath.push(start);
        HashMap<BlockPos, IAcceleratorNode> posToNode = new HashMap<BlockPos, IAcceleratorNode>();
        while (!positionsToPath.isEmpty()) {
            BlockPos pos = (BlockPos)positionsToPath.pop();
            pathedPositions.add(pos);
            TileEntity tileEntity = world.func_175625_s(pos);
            IAcceleratorTube tube = AcceleratorHelpers.getAcceleratorTube(tileEntity, null);
            if (tube == null) continue;
            tube.getNode().setNetwork(this);
            tube.getNode().updateConnections(world);
            posToNode.put(pos, tube.getNode());
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                IAcceleratorNode connection = tube.getNode().getNodes()[facing.ordinal()];
                if (connection != null) {
                    BlockPos nextPos = connection.getPos();
                    if (pathedPositions.contains(nextPos)) continue;
                    positionsToPath.add(nextPos);
                    continue;
                }
                pathedPositions.add(pos.func_177972_a(facing));
            }
        }
        this.getNodes().addAll(posToNode.values());
        this.destroyNetwork = false;
    }

    public boolean isDead() {
        return this.nodes.isEmpty() || this.destroyNetwork;
    }

    public Set<IAcceleratorNode> getNodes() {
        return this.nodes;
    }
}

