/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.accelerator.graph;

import com.builtbroken.atomic.content.machines.accelerator.graph.AcceleratorNode;
import com.builtbroken.atomic.content.machines.accelerator.graph.AcceleratorWorld;
import com.builtbroken.atomic.content.machines.accelerator.particle.AcceleratorParticle;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="atomicscience")
public class AcceleratorHandler {
    private static final HashMap<Integer, AcceleratorWorld> dimToAcceleratorWorld = new HashMap();

    public static AcceleratorWorld get(World world) {
        return AcceleratorHandler.get(world.field_73011_w.getDimension());
    }

    public static AcceleratorWorld get(int dim) {
        return dimToAcceleratorWorld.get(dim);
    }

    public static AcceleratorWorld getOrCreate(World world) {
        return AcceleratorHandler.getOrCreate(world.field_73011_w.getDimension());
    }

    public static AcceleratorWorld getOrCreate(int dim) {
        AcceleratorWorld acceleratorWorld = AcceleratorHandler.get(dim);
        if (acceleratorWorld == null) {
            acceleratorWorld = new AcceleratorWorld(dim);
            dimToAcceleratorWorld.put(dim, acceleratorWorld);
        }
        return acceleratorWorld;
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        World world;
        AcceleratorWorld acceleratorWorld;
        if (event.phase == TickEvent.Phase.END && (acceleratorWorld = AcceleratorHandler.get(world = event.world)) != null && event.side.isServer()) {
            acceleratorWorld.update(world);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.ClientTickEvent event) {
    }

    @SubscribeEvent
    public static void onUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        AcceleratorWorld acceleratorWorld = AcceleratorHandler.get(world);
        if (acceleratorWorld != null) {
            acceleratorWorld.unload(world);
            dimToAcceleratorWorld.remove(world.field_73011_w.getDimension());
        }
    }

    public static void newParticle(World world, AcceleratorNode node, ItemStack item, int energyToStart) {
        AcceleratorWorld acceleratorWorld = AcceleratorHandler.getOrCreate(world);
        AcceleratorParticle particle = new AcceleratorParticle(world.field_73011_w.getDimension(), node.getPos(), node.getDirection(), energyToStart).setCurrentNode(node).setItem(item.func_77946_l());
        node.addParticle(particle);
    }

    public static void spawnParticleInWorld(AcceleratorParticle particle) {
    }
}

