/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.content.machines.accelerator.graph;

import com.builtbroken.atomic.api.accelerator.IAcceleratorNode;
import com.builtbroken.atomic.content.machines.accelerator.graph.AcceleratorNetwork;
import java.util.Comparator;
import java.util.Set;
import net.minecraft.util.math.BlockPos;

public class AcceleratorDebug {
    public static void printNetwork(AcceleratorNetwork network) {
        if (network == null) {
            System.out.println("No network");
            return;
        }
        Set<IAcceleratorNode> nodes = network.getNodes();
        int minX = nodes.stream().min(Comparator.comparingInt(node -> node.getPos().func_177958_n())).get().getPos().func_177958_n();
        int minZ = nodes.stream().min(Comparator.comparingInt(node -> node.getPos().func_177952_p())).get().getPos().func_177952_p();
        int maxX = nodes.stream().max(Comparator.comparingInt(node -> node.getPos().func_177958_n())).get().getPos().func_177958_n();
        int maxZ = nodes.stream().max(Comparator.comparingInt(node -> node.getPos().func_177952_p())).get().getPos().func_177952_p();
        int sizeX = Math.abs(maxX - minX) + 10;
        int sizeY = Math.abs(maxZ - minZ) + 10;
        if (sizeX == 0) {
            sizeX = 1;
        }
        if (sizeY == 0) {
            sizeY = 1;
        }
        System.out.println(minX + ", " + minZ + " - " + maxX + ", " + maxZ + "  " + sizeX + "x" + sizeY);
        char[][] grid = new char[sizeX][sizeY];
        nodes.forEach(node -> {
            BlockPos blockPos = node.getPos();
            int x = blockPos.func_177958_n() - minX + 2;
            int z = blockPos.func_177952_p() - minZ + 2;
            System.out.println(blockPos);
            System.out.println(x + ", " + z + "  " + grid.length + "x" + grid[0].length + "\n");
            int count = 0;
            for (IAcceleratorNode n : node.getNodes()) {
                System.out.println(n);
                if (n == null) continue;
                ++count;
            }
            grid[x][z] = Character.forDigit(count, 10);
        });
        for (int x = 0; x < grid.length; ++x) {
            for (int z = 0; z < grid[x].length; ++z) {
                char c = grid[x][z];
                if (c == '\u0000') {
                    c = ' ';
                }
                System.out.print(c);
            }
            System.out.println();
        }
    }
}

